/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class PlateGeometryOracle {
    public static String figureGeometry(DataSetRegistrationDetails<ImageDataSetInformation> registrationDetails, IEncapsulatedBasicOpenBISService openBisService) {
        List<ImageFileInfo> images = registrationDetails.getDataSetInformation().getImageDataSetStructure().getImages();
        List<WellLocation> locations = PlateGeometryOracle.extractLocations(images);
        List<String> plateGeometries = PlateGeometryOracle.loadPlateGeometries(openBisService);
        return PlateGeometryOracle.figureGeometry(locations, plateGeometries);
    }

    private static List<String> loadPlateGeometries(IEncapsulatedBasicOpenBISService openbisService) {
        Collection<VocabularyTerm> terms = openbisService.listVocabularyTerms("$PLATE_GEOMETRY");
        ArrayList<String> plateGeometries = new ArrayList<String>();
        for (VocabularyTerm v : terms) {
            plateGeometries.add(v.getCode());
        }
        return plateGeometries;
    }

    private static List<WellLocation> extractLocations(List<ImageFileInfo> images) {
        ArrayList<WellLocation> locations = new ArrayList<WellLocation>();
        for (ImageFileInfo image : images) {
            locations.add(image.tryGetWellLocation());
        }
        return locations;
    }

    public static String figureGeometry(List<WellLocation> plateLocations, List<String> plateGeometries) {
        return PlateGeometryOracle.getMatchingGeometry(PlateGeometryOracle.getMaxLocation(plateLocations), plateGeometries);
    }

    private static Location getMaxLocation(List<WellLocation> locations) {
        int maxX = -1;
        int maxY = -1;
        for (WellLocation l : locations) {
            if (maxX < l.getColumn()) {
                maxX = l.getColumn();
            }
            if (maxY >= l.getRow()) continue;
            maxY = l.getRow();
        }
        return new Location(maxX, maxY);
    }

    private static String getMatchingGeometry(Location location, List<String> plateGeometries) {
        HashMap<Geometry, String> map = new HashMap<Geometry, String>();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (String geometryString : plateGeometries) {
            Geometry geometry = Geometry.createFromPlateGeometryString(geometryString);
            geometries.add(geometry);
            map.put(geometry, geometryString);
        }
        Collections.sort(geometries, new Comparator<Geometry>(){

            @Override
            public int compare(Geometry a, Geometry b) {
                return a.getHeight() * a.getWidth() - b.getHeight() * b.getWidth();
            }
        });
        for (Geometry g : geometries) {
            if (!PlateGeometryOracle.isEnough(g, location)) continue;
            return (String)map.get(g);
        }
        throw new UserFailureException(String.format("Matching geometry not found (max location: %s, geometries: %s)", location, StringUtils.joinList(plateGeometries)));
    }

    private static boolean isEnough(Geometry geometry, Location location) {
        int dimX = geometry.getDimX();
        int x = location.getX();
        int dimY = geometry.getDimY();
        int y = location.getY();
        return dimX >= x && dimY >= y;
    }
}

