/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpServerConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.ExperimentFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.ProjectFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.RootFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.SpaceFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.TemplateBasedDataSetResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class FtpPathResolverRegistry
implements IFtpPathResolverRegistry {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FtpPathResolverRegistry.class);
    private List<IFtpPathResolver> pathResolvers = new ArrayList<IFtpPathResolver>();

    public FtpPathResolverRegistry(FtpServerConfig ftpServerConfig) {
        this.pathResolvers.add(new RootFolderResolver());
        this.pathResolvers.add(new SpaceFolderResolver());
        this.pathResolvers.add(new ProjectFolderResolver());
        TemplateBasedDataSetResourceResolver dataSetResolver = new TemplateBasedDataSetResourceResolver(ftpServerConfig);
        this.pathResolvers.add(new ExperimentFolderResolver(dataSetResolver));
        this.pathResolvers.add(dataSetResolver);
    }

    IFtpPathResolver tryFindResolver(String path) {
        for (IFtpPathResolver ftpFileCreator : this.pathResolvers) {
            if (!ftpFileCreator.canResolve(path)) continue;
            return ftpFileCreator;
        }
        return null;
    }

    @Override
    public FtpFile resolve(String path, FtpPathResolverContext resolverContext) {
        IFtpPathResolver resolver = this.tryFindResolver(path);
        if (resolver != null) {
            return resolver.resolve(path, resolverContext);
        }
        String message = String.format("Cannot find resolver for path '%s'. Wrong user input ?", path);
        operationLog.warn((Object)message);
        return FtpPathResolverRegistry.getNonExistingFile(path, message);
    }

    public static final FtpFile getNonExistingFile(final String path, final String errorMsgOrNull) {
        return new FtpFile(){

            public String getAbsolutePath() {
                return path;
            }

            public String getName() {
                return FilenameUtils.getName((String)path);
            }

            public boolean isHidden() {
                return false;
            }

            public boolean isDirectory() {
                return false;
            }

            public boolean isFile() {
                return false;
            }

            public boolean doesExist() {
                return false;
            }

            public boolean isReadable() {
                return false;
            }

            public boolean isWritable() {
                return false;
            }

            public boolean isRemovable() {
                return false;
            }

            public String getOwnerName() {
                return "UNKNOWN";
            }

            public String getGroupName() {
                return "UNKNOWN";
            }

            public int getLinkCount() {
                return 0;
            }

            public long getLastModified() {
                return 0L;
            }

            public boolean setLastModified(long time) {
                return false;
            }

            public long getSize() {
                return 0L;
            }

            public boolean mkdir() {
                return false;
            }

            public boolean delete() {
                return false;
            }

            public boolean move(FtpFile destination) {
                return false;
            }

            public List<FtpFile> listFiles() {
                return Collections.emptyList();
            }

            public OutputStream createOutputStream(long offset) throws IOException {
                if (errorMsgOrNull != null) {
                    throw new IOException("File '" + path + "' does not exist (" + errorMsgOrNull + ".");
                }
                throw new IOException("File '" + path + "' does not exist.");
            }

            public InputStream createInputStream(long offset) throws IOException {
                if (errorMsgOrNull != null) {
                    throw new IOException("File '" + path + "' does not exist (" + errorMsgOrNull + ".");
                }
                throw new IOException("File '" + path + "' does not exist.");
            }
        };
    }
}

