/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.images.dto;

import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import java.util.Arrays;
import java.util.List;

public class DatasetAcquiredImagesReference {
    private final String datasetCode;
    private final ImageChannelStackReference channelStackReference;
    private final List<String> channelCodesOrNull;

    public static DatasetAcquiredImagesReference createForMergedChannels(String datasetCode, ImageChannelStackReference channelStackReference) {
        return new DatasetAcquiredImagesReference(datasetCode, channelStackReference, null);
    }

    public static DatasetAcquiredImagesReference createForSingleChannel(String datasetCode, ImageChannelStackReference channelStackReference, String channelCode) {
        return new DatasetAcquiredImagesReference(datasetCode, channelStackReference, Arrays.asList(channelCode));
    }

    public static DatasetAcquiredImagesReference createForManyChannels(String datasetCode, ImageChannelStackReference channelStackReference, List<String> channelCodes) {
        return new DatasetAcquiredImagesReference(datasetCode, channelStackReference, channelCodes);
    }

    private DatasetAcquiredImagesReference(String datasetCode, ImageChannelStackReference channelStackReference, List<String> channelCodesOrNull) {
        assert (datasetCode != null);
        assert (channelStackReference != null);
        this.datasetCode = datasetCode;
        this.channelStackReference = channelStackReference;
        this.channelCodesOrNull = channelCodesOrNull;
    }

    public String getDatasetCode() {
        return this.datasetCode;
    }

    public ImageChannelStackReference getChannelStackReference() {
        return this.channelStackReference;
    }

    public boolean isMergeAllChannels(List<String> allChannelsCodes) {
        if (this.channelCodesOrNull == null) {
            return true;
        }
        List<String> wantedChannelCodes = this.channelCodesOrNull;
        if (allChannelsCodes.size() == 1) {
            return false;
        }
        for (String existingChannelCode : allChannelsCodes) {
            if (wantedChannelCodes.indexOf(existingChannelCode) != -1) continue;
            return false;
        }
        return true;
    }

    public List<String> getChannelCodes(List<String> allChannelsCodes) {
        if (this.channelCodesOrNull == null) {
            return allChannelsCodes;
        }
        return this.channelCodesOrNull;
    }

    public String toString() {
        String channelsDesc = this.channelCodesOrNull == null ? "all channels merged" : "channels=" + this.channelCodesOrNull;
        return "[datasetCode=" + this.datasetCode + ", channelStackReference=" + this.channelStackReference + ", " + channelsDesc + "]";
    }
}

