/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.demo;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.HierarchicalContentTraverseUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentNodeVisitor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DemoProcessingPlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DemoProcessingPlugin.class);

    public DemoProcessingPlugin(Properties properties, File storeRoot) {
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        operationLog.info((Object)("Processing of the following datasets has been requested: " + datasets));
        IHierarchicalContentProvider contentProvider = ServiceProvider.getHierarchicalContentProvider();
        for (DatasetDescription dataset : datasets) {
            String dataSetCode = dataset.getDataSetCode();
            IHierarchicalContentNodeVisitor printingVisitor = this.createPrintingVisitor(dataSetCode);
            HierarchicalContentTraverseUtil.traverse(contentProvider, dataSetCode, printingVisitor);
        }
        operationLog.info((Object)"Processing done.");
        return null;
    }

    private IHierarchicalContentNodeVisitor createPrintingVisitor(final String datasetCode) {
        return new IHierarchicalContentNodeVisitor(){

            @Override
            public void visit(IHierarchicalContentNode node) {
                String relativePath = node.getRelativePath();
                String fullPath = String.valueOf(datasetCode) + "/" + relativePath;
                operationLog.info((Object)("Processing " + fullPath));
            }
        };
    }
}

