/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.content;

import ch.systemsx.cisd.openbis.dss.generic.shared.content.IPersistenceManager;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;

public class DelayedPersistenceManager
implements IPersistenceManager {
    private final IPersistenceManager persistenceManager;
    private final Timer timer;
    private final long delay;
    private boolean persistenceRequestScheduled;

    public DelayedPersistenceManager(IPersistenceManager persistenceManager) {
        this(persistenceManager, 10000L);
    }

    public DelayedPersistenceManager(IPersistenceManager persistenceManager, long delay) {
        this.persistenceManager = persistenceManager;
        this.delay = delay;
        this.timer = new Timer("persitence manager timer");
    }

    @Override
    public Serializable load(Serializable defaultObject) {
        return this.persistenceManager.load(defaultObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPersistence() {
        IPersistenceManager iPersistenceManager = this.persistenceManager;
        synchronized (iPersistenceManager) {
            if (this.persistenceRequestScheduled) {
                return;
            }
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DelayedPersistenceManager.this.persistenceManager.requestPersistence();
                    IPersistenceManager iPersistenceManager = DelayedPersistenceManager.this.persistenceManager;
                    synchronized (iPersistenceManager) {
                        DelayedPersistenceManager.this.persistenceRequestScheduled = false;
                    }
                }
            }, this.delay);
            this.persistenceRequestScheduled = true;
        }
    }
}

