/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class PermlinkLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public PermlinkLocatorResolver(IViewContext<ICommonClientServiceAsync> viewContext) {
        super("VIEW");
        this.viewContext = viewContext;
    }

    @Override
    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        EntityKind entityKindValueOrNull = this.tryGetEntityKindEnum(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        if (entityKindValueOrNull != null && permIdValueOrNull != null) {
            this.viewContext.getCommonService().getEntityInformationHolder(entityKindValueOrNull, permIdValueOrNull, new AbstractViewLocatorResolver.LocatorExistsCallback<IEntityInformationHolderWithPermId>(callback));
            return;
        }
        callback.onFailure(null);
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        String entityKindValueOrNull = this.tryGetEntityKind(locator);
        String permIdValueOrNull = this.tryGetPermId(locator);
        if (entityKindValueOrNull != null || permIdValueOrNull != null) {
            PermlinkLocatorResolver.checkRequiredParameter(entityKindValueOrNull, "entity");
            PermlinkLocatorResolver.checkRequiredParameter(permIdValueOrNull, "permId");
            this.openInitialEntityViewer(entityKindValueOrNull, permIdValueOrNull);
        }
    }

    protected String tryGetEntityKind(ViewLocator locator) {
        return locator.tryGetEntity();
    }

    protected EntityKind tryGetEntityKindEnum(ViewLocator locator) {
        try {
            return EntityKind.valueOf(this.tryGetEntityKind(locator));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected String tryGetPermId(ViewLocator locator) {
        return locator.getParameters().get("permId");
    }

    protected void openInitialEntityViewer(String entityKindValue, String permIdValue) throws UserFailureException {
        EntityKind entityKind = PermlinkLocatorResolver.getEntityKind(entityKindValue);
        OpenEntityDetailsTabHelper.open(this.viewContext, entityKind, permIdValue, false);
    }
}

