/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractEntityTypeGrid<T extends EntityType>
extends TypedTableGrid<T> {
    protected IDelegatedAction postRegistrationCallback = this.createRefreshGridAction();

    protected abstract void register(T var1, AsyncCallback<Void> var2);

    protected AbstractEntityTypeGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, String gridId) {
        super(viewContext, browserId, true, DisplayTypeIDGenerator.TYPE_BROWSER_GRID);
        this.extendBottomToolbar();
        this.allowMultipleSelection();
    }

    @Override
    public String getGridDisplayTypeID() {
        return this.createGridDisplayTypeID("-" + this.getEntityKindOrNull().toString());
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        final EntityKind entityKind = this.getEntityKindOrNull();
        TextToolItem button = new TextToolItem(this.viewContext.getMessage("add_new_type_button", new Object[0]), new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                AbstractEntityTypeGrid.this.createRegisterEntityTypeDialog(entityKind).show();
            }
        });
        button.setId("add-entity-type-" + this.getEntityKindOrNull());
        this.addButton(button);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit_type_button", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<T>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<T>> selectedItem, boolean keyPressed) {
                EntityType entityType = (EntityType)selectedItem.getBaseObject().getObjectOrNull();
                AbstractEntityTypeGrid.this.createEditEntityTypeDialog(entityKind, entityType).show();
            }
        });
        editButton.setId("edit-entity-type-" + this.getEntityKindOrNull());
        this.addButton(editButton);
        Button deleteButton = this.createDeleteButton(this.viewContext);
        deleteButton.setId("delete-entity-type-" + this.getEntityKindOrNull());
        this.enableButtonOnSelectedItems(deleteButton);
        this.addButton(deleteButton);
        this.addEntityOperationsSeparator();
    }

    protected void deleteEntityTypes(List<String> types, AsyncCallback<Void> callback) {
        this.viewContext.getCommonService().deleteEntityTypes(this.getEntityKindOrNull(), types, callback);
    }

    private Button createDeleteButton(final IViewContext<ICommonClientServiceAsync> context) {
        Button deleteButton = new Button(context.getMessage("button_delete", new Object[0]));
        deleteButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List types = AbstractEntityTypeGrid.this.getSelectedItems();
                if (types.isEmpty()) {
                    return;
                }
                final ArrayList<String> selectedTypeCodes = new ArrayList<String>();
                for (BaseEntityModel model : types) {
                    EntityType term = (EntityType)model.getBaseObject().getObjectOrNull();
                    selectedTypeCodes.add(term.getCode());
                }
                ConfirmationDialog confirmationDialog = new ConfirmationDialog(context.getMessage("delete_confirmation_title", new Object[0]), context.getMessage("delete_confirmation_message", StringUtils.joinList(selectedTypeCodes))){

                    @Override
                    protected void onYes() {
                        AbstractEntityTypeGrid.this.deleteEntityTypes(selectedTypeCodes, new RefreshCallback(AbstractEntityTypeGrid.this.viewContext));
                    }
                };
                confirmationDialog.setId("deletion-confirmation-dialog");
                confirmationDialog.show();
            }
        });
        return deleteButton;
    }

    private Window createRegisterEntityTypeDialog(EntityKind entityKind) {
        String title = this.viewContext.getMessage("add_type_title_template", entityKind.getDescription());
        T newEntityType = this.createNewEntityType();
        return this.createRegisterEntityTypeDialog(title, newEntityType, entityKind);
    }

    protected abstract T createNewEntityType();

    protected Window createRegisterEntityTypeDialog(String title, T newEntityType, EntityKind entityKind) {
        return new AddEntityTypeDialog<T>(this.viewContext, title, this.postRegistrationCallback, (EntityType)newEntityType, entityKind){

            @Override
            protected void register(T entityType, AsyncCallback<Void> registrationCallback) {
                AbstractEntityTypeGrid.this.register(entityType, registrationCallback);
            }
        };
    }

    protected Window createEditEntityTypeDialog(EntityKind entityKind, T entityType) {
        String code = ((Code)entityType).getCode();
        String title = this.viewContext.getMessage("edit_type_title_template", entityKind.getDescription(), code);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback, (EntityType)entityType, entityKind){
            private final DescriptionField descriptionField;
            private final ScriptChooserField scriptChooser;
            private final /* synthetic */ EntityType val$entityType;
            private final /* synthetic */ EntityKind val$entityKind;
            {
                this.val$entityType = entityType;
                this.val$entityKind = entityKind;
                super($anonymous0, $anonymous1, $anonymous2);
                this.descriptionField = 5.createDescriptionField(AbstractEntityTypeGrid.this.viewContext);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, entityType.getDescription());
                this.addField((Widget)this.descriptionField);
                Script script = entityType.getValidationScript();
                this.scriptChooser = AbstractEntityTypeGrid.this.createScriptChooserField(AbstractEntityTypeGrid.this.viewContext, script != null ? script.getName() : null, true, ScriptType.ENTITY_VALIDATION, entityKind);
                this.addField((Widget)this.scriptChooser);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                this.val$entityType.setDescription((String)this.descriptionField.getValue());
                Script script = new Script();
                script.setName((String)this.scriptChooser.getValue());
                this.val$entityType.setValidationScript(script);
                ((ICommonClientServiceAsync)AbstractEntityTypeGrid.this.viewContext.getService()).updateEntityType(this.val$entityKind, this.val$entityType, registrationCallback);
            }
        };
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<T>> createColumnsDefinition() {
        ColumnDefsAndConfigs schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    protected ScriptChooserField createScriptChooserField(IViewContext<ICommonClientServiceAsync> context, String initialValue, boolean visible, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        ScriptChooserField field = ScriptChooserField.create(context.getMessage("validation_script", new Object[0]), false, initialValue, context, scriptTypeOrNull, entityKindOrNull);
        FieldUtil.setVisibility(visible, new Field[]{field});
        return field;
    }

    private final class RefreshCallback
    extends AbstractAsyncCallback<Void> {
        private RefreshCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Void result) {
            AbstractEntityTypeGrid.this.refresh();
        }
    }
}

