/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.AttachmentFileUploadField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.FileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class AttachmentsFileFieldManager
extends FileFieldManager<AttachmentFileUploadField> {
    private static final int DEFAULT_NUMBER_OF_ATTACHMENTS = 0;
    private final int initialNumberOfFields;
    private LabelField addAttachmentLink;

    public AttachmentsFileFieldManager(String sessionKey, IMessageProvider messageProvider) {
        this(sessionKey, 0, messageProvider);
    }

    private AttachmentsFileFieldManager(String sessionKey, int initialNumberOfFields, IMessageProvider messageProvider) {
        super(sessionKey, initialNumberOfFields, messageProvider.getMessage("file", new Object[0]), messageProvider);
        this.initialNumberOfFields = initialNumberOfFields;
    }

    @Override
    protected AttachmentFileUploadField createFileUploadField() {
        return new AttachmentFileUploadField(this.messageProvider);
    }

    public void addAttachmentFieldSetsToPanel(FormPanel panel) {
        this.addAttachmentLink = this.createAddAttachmentLink(this.messageProvider.getMessage("add_attachment", new Object[0]), panel);
        panel.add((Widget)this.addAttachmentLink);
        for (AttachmentFileUploadField attachmentField : this.getFields()) {
            this.addFileFieldsetToPanel(attachmentField, panel);
        }
    }

    public void resetAttachmentFieldSetsInPanel(FormPanel panel) {
        for (AttachmentFileUploadField attachmentField : this.getFields()) {
            this.removeFileFieldsetFromPanel(attachmentField, panel);
        }
        this.getFields().clear();
        int i = 0;
        while (i < this.initialNumberOfFields) {
            AttachmentFileUploadField newField = (AttachmentFileUploadField)((Object)this.addField());
            this.addFileFieldsetToPanel(newField, panel);
            ++i;
        }
        panel.layout();
    }

    private void removeFileFieldsetFromPanel(AttachmentFileUploadField attachmentField, FormPanel panel) {
        panel.remove((Widget)attachmentField.getFieldSet());
    }

    private void addFileFieldsetToPanel(AttachmentFileUploadField attachmentField, FormPanel panel) {
        panel.add((Widget)attachmentField.getFieldSet());
    }

    public List<NewAttachment> extractAttachments() {
        ArrayList<NewAttachment> result = new ArrayList<NewAttachment>();
        for (AttachmentFileUploadField field : this.getFields()) {
            NewAttachment attachmentOrNull = field.tryExtractAttachment();
            if (attachmentOrNull == null) continue;
            result.add(attachmentOrNull);
        }
        return result;
    }

    private LabelField createAddAttachmentLink(String label, final FormPanel panel) {
        String link = LinkRenderer.renderAsLink(label);
        LabelField result = new LabelField(link);
        result.setOriginalValue((Object)link);
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                AttachmentFileUploadField newField = (AttachmentFileUploadField)((Object)AttachmentsFileFieldManager.this.addField());
                AttachmentsFileFieldManager.this.addFileFieldsetToPanel(newField, panel);
                panel.layout();
            }
        });
        return result;
    }
}

