/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.viewer;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.dialog.MetaprojectDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.form.MetaprojectEditForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.viewer.MetaprojectPropertiesPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MetaprojectViewer
extends AbstractViewerWithVerticalSplit<IEntityInformationHolder>
implements IDatabaseModificationObserver {
    private static final String PREFIX = "metaproject-viewer_";
    public static final String ID_PREFIX = "openbis_metaproject-viewer_";
    private static final String DISPLAY_ID_SUFFIX = "metaproject-viewer";
    private final Long metaprojectId;
    private Metaproject originalMetaproject;

    public static DatabaseModificationAwareComponent create(IViewContext<?> viewContext, Long metaprojectId) {
        MetaprojectViewer viewer = new MetaprojectViewer(viewContext, metaprojectId);
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    private MetaprojectViewer(IViewContext<?> viewContext, Long metaprojectId) {
        super(viewContext, MetaprojectViewer.createId(metaprojectId));
        this.metaprojectId = metaprojectId;
        this.displayIdSuffix = DISPLAY_ID_SUFFIX;
        this.setLayout((Layout)new BorderLayout());
        this.extendToolBar();
        this.reloadAllData();
    }

    public static String createId(Long metaprojectId) {
        return ID_PREFIX + metaprojectId;
    }

    @Override
    protected void fillBreadcrumbWidgets(List<Widget> widgets) {
        widgets.add((Widget)new Label(this.originalMetaproject.getOwnerId()));
        super.fillBreadcrumbWidgets(widgets);
    }

    private void extendToolBar() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addToolBarButton(this.createDeleteButton(new IDelegatedAction(){

            @Override
            public void execute() {
                new MetaprojectDeletionConfirmationDialog(MetaprojectViewer.this.viewContext, MetaprojectViewer.this.originalMetaproject.getId(), MetaprojectViewer.this.createPermanentDeletionCallback()).show();
            }
        }));
    }

    @Override
    protected void reloadAllData() {
        this.reloadData(new AbstractAsyncCallback<Metaproject>(this.viewContext){

            @Override
            protected void process(Metaproject result) {
                MetaprojectViewer.this.recreateView(result);
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                MetaprojectViewer.this.setupRemovedEntityView();
            }
        });
    }

    protected void reloadData(AbstractAsyncCallback<Metaproject> callback) {
        this.viewContext.getCommonService().getMetaproject(this.metaprojectId, callback);
    }

    private void recreateView(Metaproject metaproject) {
        this.updateOriginalMetaproject(metaproject);
        this.removeAll();
        MetaprojectPropertiesPanel properties = new MetaprojectPropertiesPanel(this.viewContext, this.metaprojectId);
        this.add((Widget)properties, (LayoutData)this.createLeftBorderLayoutData());
        this.configureLeftPanel((Component)properties);
        final Html loading = new Html(this.viewContext.getMessage("load_in_progress", new Object[0]));
        this.add((Widget)loading, (LayoutData)MetaprojectViewer.createRightBorderLayoutData());
        this.layout();
        GWTUtils.executeDelayed(new IDelegatedAction(){

            @Override
            public void execute() {
                final MetaprojectEntities entities = new MetaprojectEntities(MetaprojectViewer.this.viewContext, MetaprojectViewer.this.getId());
                entities.addListener(MetaprojectEntities.ENTITIES_CHANGED, (Listener)new Listener<BaseEvent>(){

                    public void handleEvent(BaseEvent be) {
                        MetaprojectViewer.this.reloadAllData();
                    }
                });
                entities.showEntities(MetaprojectViewer.this.metaprojectId, new IDelegatedAction(){

                    @Override
                    public void execute() {
                        MetaprojectViewer.this.remove((Component)loading);
                        MetaprojectViewer.this.add((Widget)entities, (LayoutData)MetaprojectViewer.createRightBorderLayoutData());
                        MetaprojectViewer.this.layout();
                    }
                });
            }
        });
    }

    private void updateOriginalMetaproject(Metaproject metaproject) {
        this.originalMetaproject = metaproject;
        this.updateBreadcrumbs();
        this.setToolBarButtonsEnabled(true);
    }

    @Override
    public void setupRemovedEntityView() {
        this.removeAll();
        this.updateTitle(String.valueOf(this.getOriginalDataDescription()) + " does not exist any more.");
        this.setToolBarButtonsEnabled(false);
    }

    @Override
    protected String getOriginalDataDescription() {
        return String.valueOf(this.viewContext.getMessage("metaproject", new Object[0])) + " " + this.originalMetaproject.getName();
    }

    @Override
    protected void showEntityEditor(boolean inBackground) {
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = MetaprojectEditForm.create(MetaprojectViewer.this.viewContext, MetaprojectViewer.this.metaprojectId);
                return DefaultTabItem.create(this.getTabTitle(), component, MetaprojectViewer.this.viewContext, true);
            }

            @Override
            public String getId() {
                return MetaprojectEditForm.createId(MetaprojectViewer.this.metaprojectId);
            }

            @Override
            public String getTabTitle() {
                return AbstractRegistrationForm.getEditTitle(MetaprojectViewer.this.viewContext, "metaproject", MetaprojectViewer.this.originalMetaproject);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.METAPROJECT, HelpPageIdentifier.HelpPageAction.EDIT);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.reloadAllData();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet<DatabaseModificationKind> result = new HashSet<DatabaseModificationKind>();
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.METAPROJECT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.EXPERIMENT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.SAMPLE);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.DATA_SET);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.MATERIAL);
        return result.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_metaproject", new Object[0]);
    }
}

