/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class VocabularySelectionWidget
extends DropDownList<BaseModelData, Vocabulary> {
    private static final String PREFIX = "vocabulary-select";
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public VocabularySelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, PREFIX, "vocabulary", "code", viewContext.getMessage("vocabulary", new Object[0]), viewContext.getMessage("vocabulary", new Object[0]));
        this.viewContext = viewContext;
        this.setWidth(100);
    }

    private static BaseModelData createModel(Vocabulary vocabulary) {
        return VocabularySelectionWidget.createModel(vocabulary, vocabulary.getCode());
    }

    private static BaseModelData createModel(Object object, String code) {
        BaseModelData model = new BaseModelData();
        model.set("code", (Object)code);
        model.set("object", object);
        return model;
    }

    @Override
    protected List<BaseModelData> convertItems(List<Vocabulary> list) {
        ArrayList<BaseModelData> result = new ArrayList<BaseModelData>();
        for (Vocabulary vocabulary : list) {
            result.add(VocabularySelectionWidget.createModel(vocabulary));
        }
        return result;
    }

    @Override
    protected void loadData(final AbstractAsyncCallback<List<Vocabulary>> callback) {
        DefaultResultSetConfig<String, TableModelRowWithObject<Vocabulary>> criteria = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getService().listVocabularies(false, true, criteria, new AsyncCallback<TypedTableResultSet<Vocabulary>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(TypedTableResultSet<Vocabulary> result) {
                ResultSet<TableModelRowWithObject<Vocabulary>> resultSet = result.getResultSet();
                VocabularySelectionWidget.this.resultSetKey = resultSet.getResultSetKey();
                List<TableModelRowWithObject<Vocabulary>> rows = resultSet.getList().extractOriginalObjects();
                ArrayList<Vocabulary> vocabularies = new ArrayList<Vocabulary>();
                for (TableModelRowWithObject<Vocabulary> row : rows) {
                    vocabularies.add(row.getObjectOrNull());
                }
                callback.onSuccess(vocabularies);
                VocabularySelectionWidget.this.removeResultSetFromCache();
            }
        });
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY)};
    }
}

