/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public abstract class AbstractSaveDialog
extends Window {
    private static final int FIELD_WIDTH = 450;
    private static final int SAVE_DIALOG_WIDTH = 600;
    public static final String SAVE_BUTTON_ID = "openbis_dialog-save-button";
    public static final String CANCEL_BUTTON_ID = "openbis_dialog-cancel-button";
    private final IDelegatedAction postSaveCallback;
    private final IViewContext<?> viewContext;
    protected final FormPanel form;
    protected Button saveButton;

    protected abstract void save(AsyncCallback<Void> var1);

    public AbstractSaveDialog(IViewContext<?> viewContext, String title, IDelegatedAction postSaveCallback) {
        this.postSaveCallback = postSaveCallback;
        this.viewContext = viewContext;
        this.setHeading(title);
        this.setModal(true);
        this.setWidth(600);
        this.form = new FormPanel();
        this.form.setHeaderVisible(false);
        this.form.setBorders(false);
        this.form.setBodyBorder(false);
        this.form.setFieldWidth(450);
        this.add((Component)this.form);
        this.saveButton = this.createSaveButton();
        this.addButton(this.saveButton);
        this.addButton(this.createCancelButton());
    }

    public final void addField(Widget widget) {
        this.form.add(widget);
    }

    private Button createCancelButton() {
        Button button = new Button(this.viewContext.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                AbstractSaveDialog.this.hide();
            }
        });
        button.setId(CANCEL_BUTTON_ID);
        return button;
    }

    private Button createSaveButton() {
        Button button = new Button(this.viewContext.getMessage("button_save", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractSaveDialog.this.form.isValid()) {
                    AbstractSaveDialog.this.save(new SaveDialogCallback(AbstractSaveDialog.this.viewContext));
                }
            }
        });
        button.setId(SAVE_BUTTON_ID);
        return button;
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        AbstractSaveDialog.setFocusToFirstField(this.form.getFields());
    }

    public static void setFocusToFirstField(List<Field<?>> fields) {
        int fieldNumber = 0;
        while (fieldNumber < fields.size()) {
            Field<?> field = fields.get(fieldNumber);
            if (!field.isEnabled()) continue;
            field.focus();
            return;
        }
    }

    public final class SaveDialogCallback
    extends AbstractAsyncCallback<Void> {
        private SaveDialogCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        public final void process(Void result) {
            AbstractSaveDialog.this.hide();
            AbstractSaveDialog.this.postSaveCallback.execute();
        }
    }
}

