/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;

public class ToolTipAction {
    private final Component target;
    private final Listener<ComponentEvent> listener;
    private IDelegatedAction action;
    private Timer invokeTimer;

    public ToolTipAction(Component target) {
        this.target = target;
        this.listener = this.createListener(target);
    }

    private Listener<ComponentEvent> createListener(final Component aTarget) {
        return new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent ce) {
                Element source = aTarget.getElement();
                EventType type = ce.getType();
                if (type == Events.OnMouseOver) {
                    EventTarget from = ce.getEvent().getRelatedEventTarget();
                    if (from == null || com.google.gwt.dom.client.Element.is((Node)source) && com.google.gwt.dom.client.Element.is((JavaScriptObject)from) && !DOM.isOrHasChild((Element)source, (Element)((Element)com.google.gwt.dom.client.Element.as((JavaScriptObject)from)))) {
                        ToolTipAction.this.onTargetOver(ce);
                    }
                } else if (type == Events.OnMouseOut) {
                    EventTarget to = ce.getEvent().getRelatedEventTarget();
                    if (to == null || com.google.gwt.dom.client.Element.is((Node)source) && com.google.gwt.dom.client.Element.is((JavaScriptObject)to) && !DOM.isOrHasChild((Element)source, (Element)((Element)com.google.gwt.dom.client.Element.as((JavaScriptObject)to)))) {
                        ToolTipAction.this.onTargetOut(ce);
                    }
                } else if (type == Events.Hide || type == Events.Detach) {
                    ToolTipAction.this.hide();
                }
            }
        };
    }

    public void setAction(IDelegatedAction action) {
        this.action = action;
        ToolTipAction.initListener(this.target, this.listener);
    }

    private void onTargetOver(ComponentEvent ce) {
        if (!ce.within(this.target.getElement())) {
            return;
        }
        this.delayInvoke();
    }

    private void onTargetOut(ComponentEvent ce) {
        this.cancelInvocation();
    }

    private void hide() {
        this.cancelInvocation();
    }

    private void delayInvoke() {
        this.invokeTimer = new Timer(){

            public void run() {
                ToolTipAction.this.invoke();
            }
        };
        this.invokeTimer.schedule(500);
    }

    private void invoke() {
        if (this.action != null) {
            this.action.execute();
        }
        if (this.target != null) {
            ToolTipAction.removeListener(this.target, this.listener);
        }
    }

    private void cancelInvocation() {
        if (this.invokeTimer != null) {
            this.invokeTimer.cancel();
            this.invokeTimer = null;
        }
    }

    private static void initListener(Component target, Listener<ComponentEvent> listener) {
        target.addListener(Events.OnMouseOver, listener);
        target.addListener(Events.OnMouseOut, listener);
        target.addListener(Events.Hide, listener);
        target.addListener(Events.Detach, listener);
        target.sinkEvents(48);
    }

    private static void removeListener(Component target, Listener<ComponentEvent> listener) {
        target.removeListener(Events.OnMouseOver, listener);
        target.removeListener(Events.OnMouseOut, listener);
        target.removeListener(Events.OnMouseMove, listener);
        target.removeListener(Events.Hide, listener);
        target.removeListener(Events.Detach, listener);
    }
}

