/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.mvc.AppEvent;
import com.extjs.gxt.ui.client.mvc.Controller;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.google.gwt.user.client.Element;

public class WindowUtils {
    public static void openWindow(String url) {
        DispatcherHelper.dispatchOpenUrlEvent(url);
    }

    public static void redirect(String url, String target) {
        DispatcherHelper.dispatchRedirectUrlEvent(url, target);
    }

    public static Controller createOpenUrlController() {
        return new BrowserUrlController();
    }

    public static void resize(Window window, Element windowContent) {
        int preferedWidth = windowContent.getOffsetWidth() + window.getFrameWidth() + 20;
        int preferedHeight = windowContent.getOffsetHeight() + window.getFrameHeight() + 20;
        int maxWidth = 9 * XDOM.getBody().getOffsetWidth() / 10;
        int maxHeight = 9 * XDOM.getBody().getOffsetHeight() / 10;
        int w = Math.min(maxWidth, preferedWidth);
        int h = Math.min(maxHeight, preferedHeight);
        window.setSize(w, h);
        window.center();
    }

    private static void doOpenWindow(String url, String target) {
        boolean opened = WindowUtils.openWindow(url, target, "scrollbars=yes,resizable=yes");
        if (!opened) {
            MessageBox.alert((String)"", (String)"A pop-up blocker has been detected. Please disable all the pop-up blockers for this site.", null);
            return;
        }
    }

    private static native boolean openWindow(String var0, String var1, String var2);

    private static class BrowserUrlController
    extends Controller {
        public BrowserUrlController() {
            this.registerEventTypes(new EventType[]{AppEvents.OpenUrlEvent.OPEN_URL_EVENT});
        }

        public void handleEvent(AppEvent event) {
            if (event.getType() == AppEvents.OpenUrlEvent.OPEN_URL_EVENT) {
                AppEvents.OpenUrlEvent openUrlEvent = (AppEvents.OpenUrlEvent)event;
                WindowUtils.doOpenWindow(openUrlEvent.getURL(), openUrlEvent.getTargetWindow());
            }
        }
    }
}

