/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public abstract class AbstractExpressionProvider<T extends AbstractExpression>
extends AbstractCommonTableModelProvider<T> {
    protected final String gridId;

    public AbstractExpressionProvider(ICommonServer commonServer, String sessionToken, String gridId) {
        super(commonServer, sessionToken);
        this.gridId = gridId;
    }

    @Override
    protected TypedTableModel<T> createTableModel() {
        List<T> expressions = this.listExpressions();
        TypedTableModelBuilder<AbstractExpression> builder = new TypedTableModelBuilder<AbstractExpression>();
        this.addAdditionalColumn(builder);
        builder.addColumn("NAME");
        builder.addColumn("DESCRIPTION");
        builder.addColumn("EXPRESSION").hideByDefault();
        builder.addColumn("IS_PUBLIC").hideByDefault();
        builder.addColumn("REGISTRATOR").hideByDefault();
        builder.addColumn("REGISTRATION_DATE").hideByDefault();
        for (AbstractExpression expression : expressions) {
            builder.addRow(expression);
            this.addAdditionalColumnValue(builder, expression);
            builder.column("NAME").addString(expression.getName());
            builder.column("DESCRIPTION").addString(expression.getDescription());
            builder.column("EXPRESSION").addString(expression.getExpression());
            builder.column("IS_PUBLIC").addString(SimpleYesNoRenderer.render(expression.isPublic()));
            builder.column("REGISTRATOR").addPerson(expression.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(expression.getRegistrationDate());
        }
        return builder.getModel();
    }

    protected void addAdditionalColumn(TypedTableModelBuilder<T> builder) {
    }

    protected void addAdditionalColumnValue(TypedTableModelBuilder<T> builder, T expression) {
    }

    protected abstract List<T> listExpressions();
}

