/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class AuthorizationGroupProvider
extends AbstractCommonTableModelProvider<AuthorizationGroup> {
    public AuthorizationGroupProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<AuthorizationGroup> createTableModel() {
        List<AuthorizationGroup> groups = this.commonServer.listAuthorizationGroups(this.sessionToken);
        TypedTableModelBuilder<AuthorizationGroup> builder = new TypedTableModelBuilder<AuthorizationGroup>();
        builder.addColumn("CODE");
        builder.addColumn("DESCRIPTION");
        builder.addColumn("REGISTRATOR");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300);
        for (AuthorizationGroup group : groups) {
            builder.addRow(group);
            builder.column("CODE").addString(group.getCode());
            builder.column("DESCRIPTION").addString(group.getDescription());
            builder.column("REGISTRATOR").addPerson(group.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(group.getRegistrationDate());
        }
        return builder.getModel();
    }
}

