/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

public class DataSetUpdatesPredicate
extends AbstractPredicate<DataSetUpdatesDTO> {
    private final AbstractTechIdPredicate.DataSetTechIdPredicate dataSetTechIdPredicate = new AbstractTechIdPredicate.DataSetTechIdPredicate();
    private final SampleOwnerIdentifierPredicate samplePredicate = new SampleOwnerIdentifierPredicate();

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.dataSetTechIdPredicate.init(provider);
        this.samplePredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "data set updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, DataSetUpdatesDTO updates) {
        assert (this.dataSetTechIdPredicate.initialized) : "Predicate has not been initialized";
        Status status = this.dataSetTechIdPredicate.doEvaluation(person, allowedRoles, updates.getDatasetId());
        if (!status.equals(Status.OK)) {
            return status;
        }
        SampleIdentifier sampleIdentifierOrNull = updates.getSampleIdentifierOrNull();
        if (sampleIdentifierOrNull != null) {
            status = this.samplePredicate.doEvaluation(person, allowedRoles, sampleIdentifierOrNull);
        }
        return status;
    }
}

