/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IEntityOperationChecker;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityResolverQueryFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IEntityResolverQuery;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import javax.annotation.Resource;

public abstract class AbstractBusinessObjectFactory {
    @Resource(name="dao-factory")
    private IDAOFactory daoFactory;
    @Resource(name="dss-factory")
    private IDataStoreServiceFactory dssFactory;
    protected IRelationshipService relationshipService;
    protected IEntityOperationChecker entityOperationChecker;
    private IServiceConversationClientManagerLocal conversationClient;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    private final IEntityResolverQuery entityResolver = EntityResolverQueryFactory.create();

    protected AbstractBusinessObjectFactory() {
    }

    protected AbstractBusinessObjectFactory(IDAOFactory daoFactory, IDataStoreServiceFactory dssFactory, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this();
        this.daoFactory = daoFactory;
        this.dssFactory = dssFactory;
        this.relationshipService = relationshipService;
        this.entityOperationChecker = entityOperationChecker;
        this.conversationClient = conversationClient;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    protected final IDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    protected final IDataStoreServiceFactory getDSSFactory() {
        return this.dssFactory;
    }

    protected final IRelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    protected IEntityOperationChecker getEntityOperationChecker() {
        return this.entityOperationChecker;
    }

    protected IServiceConversationClientManagerLocal getConversationClient() {
        return this.conversationClient;
    }

    protected IManagedPropertyEvaluatorFactory getManagedPropertyEvaluatorFactory() {
        return this.managedPropertyEvaluatorFactory;
    }

    public IEntityResolverQuery getEntityResolver() {
        return this.entityResolver;
    }
}

