/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IGridCustomFilterOrColumnBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.ExpressionUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.HashSet;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class GridCustomColumnBO
extends AbstractBusinessObject
implements IGridCustomFilterOrColumnBO {
    private static final String CUSTOM_COLUMN_ID_PREFIX = "$";
    private GridCustomColumnPE column;

    public GridCustomColumnBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public void define(NewColumnOrFilter newColumn) throws UserFailureException {
        this.column = new GridCustomColumnPE();
        this.column.setCode(GridCustomColumnBO.createUniqueCode(newColumn));
        this.column.setLabel(newColumn.getName());
        this.column.setDescription(newColumn.getDescription());
        this.column.setExpression(this.checkExpressionFreeOfParameters(newColumn.getExpression()));
        this.column.setGridId(newColumn.getGridId());
        this.column.setPublic(newColumn.isPublic());
        this.column.setRegistrator(this.findPerson());
    }

    private static String createUniqueCode(NewColumnOrFilter newColumn) {
        String name = newColumn.getName();
        String code = name.replace(" ", "_");
        code = code.toLowerCase();
        return CUSTOM_COLUMN_ID_PREFIX + code;
    }

    @Override
    public void loadDataByTechId(TechId id) {
        try {
            this.column = (GridCustomColumnPE)this.getGridCustomColumnDAO().getByTechId(id);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public void deleteByTechId(TechId groupId) throws UserFailureException {
        this.loadDataByTechId(groupId);
        try {
            this.getGridCustomColumnDAO().delete(this.column);
        }
        catch (DataAccessException ex) {
            GridCustomColumnBO.throwException(ex, String.format("Column '%s'", this.column));
        }
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.column != null) : "Column not defined";
        try {
            this.getGridCustomColumnDAO().createColumn(this.column);
        }
        catch (DataAccessException e) {
            GridCustomColumnBO.throwException(e, "Column '" + this.column + "'");
        }
    }

    @Override
    public void update(IExpressionUpdates updates) {
        this.loadDataByTechId(TechId.create(updates));
        this.column.setLabel(updates.getName());
        this.column.setDescription(updates.getDescription());
        this.column.setExpression(this.checkExpressionFreeOfParameters(updates.getExpression()));
        this.column.setPublic(updates.isPublic());
        this.validateAndSave();
    }

    private String checkExpressionFreeOfParameters(String expression) {
        HashSet<String> parameters = new HashSet<String>(ExpressionUtil.extractParameters(expression));
        if (parameters.isEmpty()) {
            return expression;
        }
        throw new UserFailureException("Unexpected parameters " + parameters + " in expression: " + expression);
    }

    private void validateAndSave() {
        this.getGridCustomColumnDAO().validateAndSaveUpdatedEntity(this.column);
    }
}

