/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class SampleOwner {
    private SpacePE spaceOrNull;
    private DatabaseInstancePE databaseInstanceOrNull;

    public SampleOwner(SpacePE spaceOrNull, DatabaseInstancePE databaseInstanceOrNull) {
        assert (spaceOrNull == null || databaseInstanceOrNull == null);
        assert (spaceOrNull != null || databaseInstanceOrNull != null);
        this.spaceOrNull = spaceOrNull;
        this.databaseInstanceOrNull = databaseInstanceOrNull;
    }

    public static SampleOwner createSpace(SpacePE group) {
        return new SampleOwner(group, null);
    }

    public static SampleOwner createDatabaseInstance(DatabaseInstancePE databaseInstance) {
        return new SampleOwner(null, databaseInstance);
    }

    public boolean isSpaceLevel() {
        return this.spaceOrNull != null;
    }

    public boolean isDatabaseInstanceLevel() {
        return this.databaseInstanceOrNull != null;
    }

    public SpacePE tryGetSpace() {
        return this.spaceOrNull;
    }

    public DatabaseInstancePE tryGetDatabaseInstance() {
        return this.databaseInstanceOrNull;
    }

    public String toString() {
        if (this.isSpaceLevel()) {
            return "space: " + this.spaceOrNull;
        }
        return "db instance: " + this.databaseInstanceOrNull;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SampleOwner)) {
            return false;
        }
        SampleOwner that = (SampleOwner)obj;
        if (this.isSpaceLevel()) {
            return this.spaceOrNull.equals(that.spaceOrNull);
        }
        return this.databaseInstanceOrNull.equals(that.databaseInstanceOrNull);
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.spaceOrNull);
        builder.append((Object)this.databaseInstanceOrNull);
        return builder.toHashCode();
    }
}

