/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.search;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractSearchManager<T> {
    protected final IHibernateSearchDAO searchDAO;
    protected final T lister;

    public AbstractSearchManager(IHibernateSearchDAO searchDAO, T lister) {
        this.searchDAO = searchDAO;
        this.lister = lister;
    }

    protected Collection<Long> restrictResultSetIfNecessary(Collection<Long> ids) {
        int maxSize = this.searchDAO.getResultSetSizeLimit();
        if (ids.size() <= maxSize) {
            return ids;
        }
        return new ArrayList<Long>(ids).subList(0, maxSize);
    }

    protected DetailedSearchAssociationCriteria findAssociatedEntities(String userId, DetailedSearchSubCriteria subCriteria) {
        List<DetailedSearchAssociationCriteria> associations = Collections.emptyList();
        List<Long> associatedIds = this.searchDAO.searchForEntityIds(userId, subCriteria.getCriteria(), DtoConverters.convertEntityKind(subCriteria.getTargetEntityKind().getEntityKind()), associations);
        return new DetailedSearchAssociationCriteria(subCriteria.getTargetEntityKind(), associatedIds);
    }

    protected void mergeSubCriteria(DetailedSearchCriteria criteria, DetailedSearchSubCriteria subCriteriaToMerge) {
        criteria.getCriteria().addAll(subCriteriaToMerge.getCriteria().getCriteria());
        criteria.setConnection(subCriteriaToMerge.getCriteria().getConnection());
        criteria.setUseWildcardSearchMode(subCriteriaToMerge.getCriteria().isUseWildcardSearchMode());
    }

    protected Collection<Long> filterSearchResultsBySubcriteria(String userId, Collection<Long> idsToFilter, DetailedSearchCriteria criteria, IRelationshipHandler relationshipHandler) {
        Collection<Long> relatedIds = relationshipHandler.findRelatedIdsByCriteria(userId, criteria, Collections.<DetailedSearchSubCriteria>emptyList());
        if (idsToFilter.size() > relatedIds.size()) {
            Map<Long, Set<Long>> relatedIdsToIds = relationshipHandler.listRelatedIdsToIds(relatedIds);
            return this.intersection(idsToFilter, relatedIdsToIds.values());
        }
        Map<Long, Set<Long>> idsToRelatedIds = relationshipHandler.listIdsToRelatedIds(idsToFilter);
        return this.filteIdsByRelationship(idsToFilter, relatedIds, idsToRelatedIds);
    }

    protected Collection<Long> intersection(Collection<Long> collection, Collection<Set<Long>> multiSet) {
        HashSet<Long> intersection = new HashSet<Long>();
        for (Set<Long> set : multiSet) {
            set.retainAll(collection);
            intersection.addAll(set);
        }
        return intersection;
    }

    protected Collection<Long> filteIdsByRelationship(Collection<Long> idsToFilter, Collection<Long> relatedIds, Map<Long, Set<Long>> relationshipMap) {
        Iterator<Long> iterator = idsToFilter.iterator();
        while (iterator.hasNext()) {
            Long id = iterator.next();
            Set<Long> relatedIdSet = relationshipMap.get(id);
            if (relatedIdSet != null && !Collections.disjoint(relatedIds, relatedIdSet)) continue;
            iterator.remove();
        }
        return idsToFilter;
    }

    static interface IRelationshipHandler {
        public Collection<Long> findRelatedIdsByCriteria(String var1, DetailedSearchCriteria var2, List<DetailedSearchSubCriteria> var3);

        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> var1);

        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> var1);
    }
}

