/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.common.spring.SpringEoDSQLExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ICorePluginDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IVocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.CodeSequenceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.CorePluginDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataSetTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataStoreDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.EventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ExternalDataManagementSystemDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.FileFormatTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ICodeSequenceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IPermIdDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.LocatorTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MaterialDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PermIdDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PostRegistrationDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ScriptDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.VocabularyDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.VocabularyTermDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.HibernateSearchContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdateScheduler;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;

public final class DAOFactory
extends AuthorizationDAOFactory
implements IDAOFactory {
    private final IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler;
    private final IFullTextIndexUpdateScheduler fullTextIndexUpdateScheduler;
    private final ISampleTypeDAO sampleTypeDAO;
    private final IHibernateSearchDAO hibernateSearchDAO;
    private final IPropertyTypeDAO propertyTypeDAO;
    private final Map<EntityKind, IEntityTypeDAO> entityTypeDAOs = new HashMap<EntityKind, IEntityTypeDAO>();
    private final Map<EntityKind, IEntityPropertyTypeDAO> entityPropertyTypeDAOs = new HashMap<EntityKind, IEntityPropertyTypeDAO>();
    private final IVocabularyDAO vocabularyDAO;
    private final IVocabularyTermDAO vocabularyTermDAO;
    private final IAttachmentDAO attachmentDAO;
    private final DataSetTypeDAO dataSetTypeDAO;
    private final FileFormatTypeDAO fileFormatTypeDAO;
    private final LocatorTypeDAO locatorTypeDAO;
    private final IMaterialDAO materialDAO;
    private final ICodeSequenceDAO codeSequenceDAO;
    private final IDataStoreDAO dataStoreDAO;
    private final IPermIdDAO permIdDAO;
    private final IEventDAO eventDAO;
    private final IAuthorizationGroupDAO authorizationGroupDAO;
    private final IScriptDAO scriptDAO;
    private final ICorePluginDAO corePluginDAO;
    private final IPostRegistrationDAO postRegistrationDAO;
    private final IEntityOperationsLogDAO entityOperationsLogDAO;
    private EntityHistoryDAO entityPropertyHistoryDAO;
    private final IExternalDataManagementSystemDAO externalDataManagementSystemDAO;

    static {
        SpringEoDSQLExceptionTranslator.activate();
    }

    public DAOFactory(DatabaseConfigurationContext context, SessionFactory sessionFactory, HibernateSearchContext hibernateSearchContext, IFullTextIndexUpdateScheduler fullTextIndexUpdateScheduler, IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler) {
        super(context, sessionFactory, fullTextIndexUpdateScheduler, dynamicPropertyEvaluationScheduler);
        EntityKind[] entityKinds;
        this.dynamicPropertyEvaluationScheduler = dynamicPropertyEvaluationScheduler;
        this.fullTextIndexUpdateScheduler = fullTextIndexUpdateScheduler;
        DatabaseInstancePE databaseInstance = this.getHomeDatabaseInstance();
        this.sampleTypeDAO = new SampleTypeDAO(sessionFactory, databaseInstance);
        this.hibernateSearchDAO = new HibernateSearchDAO(sessionFactory, hibernateSearchContext);
        this.propertyTypeDAO = new PropertyTypeDAO(sessionFactory, databaseInstance);
        this.vocabularyDAO = new VocabularyDAO(sessionFactory, databaseInstance);
        this.vocabularyTermDAO = new VocabularyTermDAO(sessionFactory, databaseInstance);
        this.attachmentDAO = new AttachmentDAO(sessionFactory, databaseInstance);
        this.dataSetTypeDAO = new DataSetTypeDAO(sessionFactory, databaseInstance);
        this.fileFormatTypeDAO = new FileFormatTypeDAO(sessionFactory, databaseInstance);
        this.locatorTypeDAO = new LocatorTypeDAO(sessionFactory, databaseInstance);
        this.materialDAO = new MaterialDAO(this.getPersistencyResources(), databaseInstance);
        this.codeSequenceDAO = new CodeSequenceDAO(sessionFactory, databaseInstance);
        this.dataStoreDAO = new DataStoreDAO(sessionFactory, databaseInstance);
        this.permIdDAO = new PermIdDAO(sessionFactory, databaseInstance);
        this.eventDAO = new EventDAO(sessionFactory, databaseInstance);
        this.authorizationGroupDAO = new AuthorizationGroupDAO(sessionFactory, databaseInstance);
        this.scriptDAO = new ScriptDAO(sessionFactory, databaseInstance);
        this.corePluginDAO = new CorePluginDAO(sessionFactory, databaseInstance);
        this.postRegistrationDAO = new PostRegistrationDAO(sessionFactory, databaseInstance);
        this.entityOperationsLogDAO = new EntityOperationsLogDAO(sessionFactory, databaseInstance);
        EntityKind[] entityKindArray = entityKinds = EntityKind.values();
        int n = entityKinds.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            EntityTypeDAO dao = new EntityTypeDAO(entityKind, sessionFactory, databaseInstance);
            this.entityTypeDAOs.put(entityKind, dao);
            this.entityPropertyTypeDAOs.put(entityKind, new EntityPropertyTypeDAO(entityKind, this.getPersistencyResources(), databaseInstance));
            ++n2;
        }
        this.entityPropertyHistoryDAO = new EntityHistoryDAO(this.getPersistencyResources(), databaseInstance);
        this.externalDataManagementSystemDAO = new ExternalDataManagementSystemDAO(sessionFactory, databaseInstance);
    }

    @Override
    public final ISampleTypeDAO getSampleTypeDAO() {
        return this.sampleTypeDAO;
    }

    @Override
    public final IHibernateSearchDAO getHibernateSearchDAO() {
        return this.hibernateSearchDAO;
    }

    @Override
    public IEntityPropertyTypeDAO getEntityPropertyTypeDAO(EntityKind entityKind) {
        return this.entityPropertyTypeDAOs.get((Object)entityKind);
    }

    @Override
    public IEntityHistoryDAO getEntityPropertyHistoryDAO() {
        return this.entityPropertyHistoryDAO;
    }

    @Override
    public IEntityTypeDAO getEntityTypeDAO(EntityKind entityKind) {
        return this.entityTypeDAOs.get((Object)entityKind);
    }

    @Override
    public IPropertyTypeDAO getPropertyTypeDAO() {
        return this.propertyTypeDAO;
    }

    @Override
    public final IVocabularyDAO getVocabularyDAO() {
        return this.vocabularyDAO;
    }

    @Override
    public final IVocabularyTermDAO getVocabularyTermDAO() {
        return this.vocabularyTermDAO;
    }

    @Override
    public final IAttachmentDAO getAttachmentDAO() {
        return this.attachmentDAO;
    }

    @Override
    public IDataSetTypeDAO getDataSetTypeDAO() {
        return this.dataSetTypeDAO;
    }

    @Override
    public IFileFormatTypeDAO getFileFormatTypeDAO() {
        return this.fileFormatTypeDAO;
    }

    @Override
    public ILocatorTypeDAO getLocatorTypeDAO() {
        return this.locatorTypeDAO;
    }

    @Override
    public IMaterialDAO getMaterialDAO() {
        return this.materialDAO;
    }

    @Override
    public ICodeSequenceDAO getCodeSequenceDAO() {
        return this.codeSequenceDAO;
    }

    @Override
    public IDataStoreDAO getDataStoreDAO() {
        return this.dataStoreDAO;
    }

    @Override
    public IPermIdDAO getPermIdDAO() {
        return this.permIdDAO;
    }

    @Override
    public IEventDAO getEventDAO() {
        return this.eventDAO;
    }

    @Override
    public IAuthorizationGroupDAO getAuthorizationGroupDAO() {
        return this.authorizationGroupDAO;
    }

    @Override
    public IScriptDAO getScriptDAO() {
        return this.scriptDAO;
    }

    public IDynamicPropertyEvaluationScheduler getDynamicPropertyEvaluationScheduler() {
        return this.dynamicPropertyEvaluationScheduler;
    }

    public IFullTextIndexUpdateScheduler getFullTextIndexUpdateScheduler() {
        return this.fullTextIndexUpdateScheduler;
    }

    @Override
    public ICorePluginDAO getCorePluginDAO() {
        return this.corePluginDAO;
    }

    @Override
    public IPostRegistrationDAO getPostRegistrationDAO() {
        return this.postRegistrationDAO;
    }

    @Override
    public IEntityOperationsLogDAO getEntityOperationsLogDAO() {
        return this.entityOperationsLogDAO;
    }

    @Override
    public IExternalDataManagementSystemDAO getExternalDataManagementSystemDAO() {
        return this.externalDataManagementSystemDAO;
    }
}

