/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.CharacterHelper;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.SearchAnalyzer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.detailed.DetailedQueryBuilder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class LuceneQueryBuilder {
    private static final String NOT = "NOT";
    private static final String OR = "OR";
    private static final String AND = "AND";
    private static final char STAR = '*';
    private static final char SPACE = ' ';
    private static final char FIELD_SEPARATOR = ':';
    private static final char[] CHARS_ESCAPED_IN_WILCARD_MODE = new char[]{':'};
    private static final char[] CHARS_ESCAPED_IN_BASIC_MODE = CHARS_ESCAPED_IN_WILCARD_MODE;

    public static Query createDetailedSearchQuery(String userId, DetailedSearchCriteria searchCriteria, List<DetailedSearchAssociationCriteria> associations, EntityKind entityKind) {
        return DetailedQueryBuilder.createQuery(userId, searchCriteria, DtoConverters.convertEntityKind(entityKind), associations);
    }

    public static String adaptQuery(String userQuery, boolean useWildcardSearchMode) {
        return LuceneQueryBuilder.adaptQuery(userQuery, useWildcardSearchMode, true);
    }

    public static String adaptQuery(String userQuery, boolean useWildcardSearchMode, boolean splitQuery) {
        char[] escapedChars = useWildcardSearchMode ? CHARS_ESCAPED_IN_WILCARD_MODE : CHARS_ESCAPED_IN_BASIC_MODE;
        String result = LuceneQueryBuilder.escapeQuery(userQuery, escapedChars);
        if (!(useWildcardSearchMode || LuceneQueryBuilder.isQuoted(result) || result.contains("*"))) {
            result = LuceneQueryBuilder.addWildcards(result, splitQuery);
        }
        return result;
    }

    private static String addWildcards(String result, boolean split) {
        String[] queryTokens = StringUtils.split((String)result, (char)' ');
        ArrayList<String> transformedTokens = new ArrayList<String>();
        String[] stringArray = queryTokens;
        int n = queryTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String qt = stringArray[n2];
            if (qt.equals(AND) || qt.equals(OR) || qt.equals(NOT)) {
                transformedTokens.add(qt);
            } else {
                transformedTokens.add(LuceneQueryBuilder.addWildcartdsToToken(qt, split));
            }
            ++n2;
        }
        return StringUtils.join(transformedTokens, (char)' ');
    }

    private static String addWildcartdsToToken(String token, boolean split) {
        Collection<Character> tokenSeparators = CharacterHelper.getTokenSeparators();
        tokenSeparators.removeAll(new ArrayList());
        String[] miniTokens = null;
        miniTokens = split ? StringUtils.split((String)token, (String)StringUtils.join(tokenSeparators, (String)"")) : new String[]{token};
        ArrayList<String> transformedMiniTokens = new ArrayList<String>();
        String[] stringArray = miniTokens;
        int n = miniTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String qt = stringArray[n2];
            transformedMiniTokens.add(String.valueOf('*') + qt + '*');
            ++n2;
        }
        return String.valueOf('(') + StringUtils.join(transformedMiniTokens, (String)" AND ") + ')';
    }

    private static boolean isQuoted(String result) {
        return result.startsWith("\"") && result.endsWith("\"");
    }

    private static String escapeQuery(String userQuery, char ... escapedChars) {
        char escapeChar = '\\';
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < userQuery.length()) {
            char ch = userQuery.charAt(i);
            char[] cArray = escapedChars;
            int n = escapedChars.length;
            int n2 = 0;
            while (n2 < n) {
                char escapedChar = cArray[n2];
                if (ch == escapedChar && (i == 0 || userQuery.charAt(i - 1) != escapeChar)) {
                    sb.append(escapeChar);
                }
                ++n2;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static Analyzer createSearchAnalyzer() {
        return new SearchAnalyzer();
    }

    public static Query parseQuery(String fieldName, String searchPattern, Analyzer analyzer) throws UserFailureException {
        QueryParser parser = new QueryParser(Version.LUCENE_31, fieldName, analyzer);
        parser.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
        return LuceneQueryBuilder.parseQuery(searchPattern, searchPattern, parser);
    }

    public static Query parseQuery(List<String> fieldNames, List<String> searchPatterns, List<Analyzer> analyzers) throws UserFailureException {
        BooleanQuery resultQuery = new BooleanQuery();
        int i = 0;
        while (i < fieldNames.size()) {
            String fieldName = fieldNames.get(i);
            String searchPattern = searchPatterns.get(i);
            Analyzer analyzer = analyzers.get(i);
            Query query = LuceneQueryBuilder.parseQuery(fieldName, searchPattern, analyzer);
            resultQuery.add(query, BooleanClause.Occur.SHOULD);
            ++i;
        }
        return resultQuery;
    }

    public static Query parseQuery(String fieldName, List<String> searchPatterns, Analyzer analyzer) throws UserFailureException {
        BooleanQuery resultQuery = new BooleanQuery();
        for (String searchPattern : searchPatterns) {
            Query query = LuceneQueryBuilder.parseQuery(fieldName, searchPattern, analyzer);
            resultQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return resultQuery;
    }

    private static Query parseQuery(String searchPattern, String wholeQuery, QueryParser parser) {
        parser.setAllowLeadingWildcard(true);
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        try {
            return parser.parse(wholeQuery);
        }
        catch (ParseException ex) {
            throw new UserFailureException(String.format("Search pattern '%s' is invalid.", searchPattern), ex);
        }
    }
}

