/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEntityTypePropertyTypeTranslator<ET extends EntityType, ETPT extends EntityTypePropertyType<ET>, ETPTPE extends EntityTypePropertyTypePE> {
    public ETPT translate(ETPTPE entityTypePropertyType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        return this.translate(entityTypePropertyType, null, null, cacheOrNull);
    }

    protected final List<ETPT> translate(Set<ETPTPE> sampleTypePropertyTypes, ET sampleType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (!HibernateUtils.isInitialized(sampleTypePropertyTypes)) {
            return DtoConverters.createUnmodifiableEmptyList();
        }
        ArrayList<ETPT> result = new ArrayList<ETPT>();
        for (EntityTypePropertyTypePE sampleTypePropertyType : sampleTypePropertyTypes) {
            result.add(this.translate(sampleTypePropertyType, sampleType, null, cacheOrNull));
        }
        Collections.sort(result);
        return result;
    }

    private final ETPT translate(ETPTPE etptPE, ET entityType, PropertyType propertyType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ETPT result = this.create();
        if (propertyType != null) {
            ((EntityTypePropertyType)result).setPropertyType(propertyType);
        } else if (entityType != null && entityType instanceof MaterialType) {
            ((EntityTypePropertyType)result).setPropertyType(PropertyTypeTranslator.translate(((EntityTypePropertyTypePE)etptPE).getPropertyType(), (MaterialType)entityType, cacheOrNull));
        } else {
            ((EntityTypePropertyType)result).setPropertyType(PropertyTypeTranslator.translate(((EntityTypePropertyTypePE)etptPE).getPropertyType(), null, cacheOrNull));
        }
        if (entityType != null) {
            ((EntityTypePropertyType)result).setEntityType(entityType);
        } else {
            ((EntityTypePropertyType)result).setEntityType(this.translate(etptPE.getEntityType(), cacheOrNull));
        }
        ((EntityTypePropertyType)result).setManagedInternally(((EntityTypePropertyTypePE)etptPE).isManagedInternally());
        ((EntityTypePropertyType)result).setMandatory(((EntityTypePropertyTypePE)etptPE).isMandatory());
        ((EntityTypePropertyType)result).setOrdinal(((EntityTypePropertyTypePE)etptPE).getOrdinal());
        ((EntityTypePropertyType)result).setSection(((EntityTypePropertyTypePE)etptPE).getSection());
        ((EntityTypePropertyType)result).setDynamic(((EntityTypePropertyTypePE)etptPE).isDynamic());
        boolean managed = ((EntityTypePropertyTypePE)etptPE).isManaged();
        ((EntityTypePropertyType)result).setManaged(managed);
        boolean shownInEditView = ((EntityTypePropertyTypePE)etptPE).isShownInEditView();
        ((EntityTypePropertyType)result).setShownInEditView(shownInEditView);
        Script script = ScriptTranslator.translate(((EntityTypePropertyTypePE)etptPE).getScript());
        if (script != null && managed && shownInEditView) {
            ((EntityTypePropertyType)result).setShowRawValue(((EntityTypePropertyTypePE)etptPE).getShowRawValue());
        }
        ((EntityTypePropertyType)result).setScript(script);
        return result;
    }

    protected final List<ETPT> translate(Set<ETPTPE> sampleTypePropertyTypes, PropertyType propertyType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (!HibernateUtils.isInitialized(sampleTypePropertyTypes)) {
            return DtoConverters.createUnmodifiableEmptyList();
        }
        ArrayList<ETPT> result = new ArrayList<ETPT>();
        for (EntityTypePropertyTypePE sampleTypePropertyType : sampleTypePropertyTypes) {
            result.add(this.translate(sampleTypePropertyType, null, propertyType, cacheOrNull));
        }
        Collections.sort(result);
        return result;
    }

    abstract ETPT create();

    abstract ET translate(EntityTypePE var1, Map<PropertyTypePE, PropertyType> var2);
}

