/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class PropertyTypeTranslator {
    private PropertyTypeTranslator() {
    }

    public static final List<PropertyType> translate(List<PropertyTypePE> propertyTypes, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ArrayList<PropertyType> result = new ArrayList<PropertyType>();
        for (PropertyTypePE propType : propertyTypes) {
            result.add(PropertyTypeTranslator.translate(propType, cacheOrNull));
        }
        return result;
    }

    public static final PropertyType translate(PropertyTypePE propertyType, MaterialType materialType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        PropertyType cachedOrNull;
        PropertyType propertyType2 = cachedOrNull = cacheOrNull == null ? null : cacheOrNull.get(propertyType);
        if (cachedOrNull != null) {
            return cachedOrNull;
        }
        PropertyType result = new PropertyType();
        if (cacheOrNull != null) {
            cacheOrNull.put(propertyType, result);
        }
        result.setId(HibernateUtils.getId(propertyType));
        result.setCode(propertyType.getCode());
        result.setSimpleCode(propertyType.getSimpleCode());
        result.setInternalNamespace(propertyType.isInternalNamespace());
        result.setManagedInternally(propertyType.isManagedInternally());
        result.setLabel(propertyType.getLabel());
        result.setDataType(DataTypeTranslator.translate(propertyType.getType()));
        result.setVocabulary(VocabularyTranslator.translate(propertyType.getVocabulary()));
        result.setMaterialType(MaterialTypeTranslator.translate(propertyType.getMaterialType(), false, cacheOrNull));
        result.setDescription(propertyType.getDescription());
        result.setSampleTypePropertyTypes(SampleTypePropertyTypeTranslator.translate(propertyType.getSampleTypePropertyTypes(), result, cacheOrNull));
        result.setMaterialTypePropertyTypes(MaterialTypePropertyTypeTranslator.translate(propertyType.getMaterialTypePropertyTypes(), result, cacheOrNull));
        result.setExperimentTypePropertyTypes(ExperimentTypePropertyTypeTranslator.translate(propertyType.getExperimentTypePropertyTypes(), result, cacheOrNull));
        result.setDataSetTypePropertyTypes(DataSetTypePropertyTypeTranslator.translate(propertyType.getDataSetTypePropertyTypes(), result, cacheOrNull));
        result.setSchema(propertyType.getSchema());
        result.setTransformation(propertyType.getTransformation());
        return result;
    }

    public static final PropertyType translate(PropertyTypePE propertyType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        return PropertyTypeTranslator.translate(propertyType, null, cacheOrNull);
    }
}

