/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AttachmentVersionsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserverWithMainObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.RevertDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.EntityHistoryGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDirectlyConnectedController;
import ch.systemsx.cisd.openbis.generic.shared.basic.IAttachmentHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractEntityDataSetsSection;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentDataSetBrowser;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentPropertiesPanel;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.ExperimentSamplesSection;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GenericExperimentViewer
extends AbstractViewerWithVerticalSplit<Experiment>
implements IDatabaseModificationObserver {
    private static final String GENERIC_EXPERIMENT_VIEWER = "generic-experiment-viewer";
    private static final String PREFIX = "generic-experiment-viewer_";
    public static final String ID_PREFIX = "openbis_generic-experiment-viewer_";
    protected final IViewContext<IGenericClientServiceAsync> localViewContext;
    protected final IIdAndCodeHolder experimentId;
    protected final BasicEntityType experimentType;
    protected Experiment experiment;
    private ExperimentPropertiesPanel propertiesPanelOrNull;
    private List<DisposableTabContent> rightPanelSectionsOrNull;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, BasicEntityType experimentType, IIdAndCodeHolder identifiable) {
        GenericExperimentViewer viewer = new GenericExperimentViewer(viewContext, experimentType, identifiable);
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    protected GenericExperimentViewer(IViewContext<IGenericClientServiceAsync> viewContext, BasicEntityType experimentType, IIdAndCodeHolder experimentId) {
        super(viewContext, GenericExperimentViewer.createId(experimentId));
        int logID = viewContext.log("create experiment viewer");
        this.experimentId = experimentId;
        this.experimentType = experimentType;
        this.localViewContext = viewContext;
        this.setLayout((Layout)new BorderLayout());
        this.extendToolBar();
        this.reloadAllData();
        viewContext.logStop(logID);
    }

    @Override
    protected void fillBreadcrumbWidgets(List<Widget> widgets) {
        Widget spaceBreadcrumb = this.createSpaceLink(((Experiment)this.originalData).getProject().getSpace());
        Widget projectBreadcrumb = this.createProjectLink(((Experiment)this.originalData).getProject());
        widgets.add(spaceBreadcrumb);
        widgets.add(projectBreadcrumb);
        super.fillBreadcrumbWidgets(widgets);
    }

    private void extendToolBar() {
        if (this.localViewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addToolBarButton(this.createDeleteButton(new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractAsyncCallback callback = GenericExperimentViewer.this.isTrashEnabled() ? GenericExperimentViewer.this.createDeletionCallback() : GenericExperimentViewer.this.createPermanentDeletionCallback();
                new ExperimentListDeletionConfirmationDialog(GenericExperimentViewer.this.localViewContext.getCommonViewContext(), (AsyncCallback<Void>)callback, (Experiment)GenericExperimentViewer.this.getOriginalData()).show();
            }
        }));
        this.addToolBarButton(this.createRevertDeletionButton(new IDelegatedAction(){

            @Override
            public void execute() {
                new RevertDeletionConfirmationDialog(GenericExperimentViewer.this.localViewContext.getCommonViewContext(), (IEntityWithDeletionInformation)GenericExperimentViewer.this.getOriginalData(), (AsyncCallback<Void>)GenericExperimentViewer.this.createRevertDeletionCallback()).show();
            }
        }));
    }

    @Override
    protected void reloadAllData() {
        this.reloadExperiment(new AbstractAsyncCallback<Experiment>(this.localViewContext){

            @Override
            protected final void process(Experiment result) {
                GenericExperimentViewer.this.experiment = result;
                GenericExperimentViewer.this.layoutExperimentDetailView();
            }
        });
    }

    protected void reloadExperiment(AbstractAsyncCallback<Experiment> callback) {
        this.localViewContext.getCommonService().getExperimentInfo(new TechId(this.experimentId), callback);
    }

    private void layoutExperimentDetailView() {
        int logId = this.localViewContext.log("layoutExperimentDetailView");
        this.updateOriginalData(this.experiment);
        this.removeAll();
        this.propertiesPanelOrNull = new ExperimentPropertiesPanel(this.experiment, this.localViewContext, this);
        Component lowerLeftComponentOrNull = this.tryCreateLowerLeftComponent();
        if (lowerLeftComponentOrNull != null) {
            this.propertiesPanelOrNull.addSouthComponent(lowerLeftComponentOrNull);
        }
        this.add((Widget)this.propertiesPanelOrNull, (LayoutData)this.createLeftBorderLayoutData());
        this.configureLeftPanel((Component)this.propertiesPanelOrNull);
        final Html loadingLabel = new Html(this.localViewContext.getMessage("load_in_progress", new Object[0]));
        this.add((Widget)loadingLabel, (LayoutData)GenericExperimentViewer.createRightBorderLayoutData());
        this.layout();
        this.localViewContext.logStop(logId);
        GWTUtils.executeDelayed(new IDelegatedAction(){

            @Override
            public void execute() {
                GenericExperimentViewer.this.remove((Component)loadingLabel);
                GenericExperimentViewer.this.rightPanelSectionsOrNull = GenericExperimentViewer.this.createRightPanel();
                SectionsPanel rightPanel = GenericExperimentViewer.this.layoutSections(GenericExperimentViewer.this.rightPanelSectionsOrNull);
                GenericExperimentViewer.this.attachManagedPropertiesSections(rightPanel, GenericExperimentViewer.this.experiment);
                GenericExperimentViewer.this.attachModuleSpecificSections(rightPanel, GenericExperimentViewer.this.experiment);
                GenericExperimentViewer.this.attachWebAppsSections(rightPanel, GenericExperimentViewer.this.experiment, WebAppContext.EXPERIMENT_DETAILS_VIEW);
                GenericExperimentViewer.this.add((Widget)rightPanel, (LayoutData)GenericExperimentViewer.createRightBorderLayoutData());
                GenericExperimentViewer.this.layout();
            }
        });
    }

    protected Component tryCreateLowerLeftComponent() {
        return null;
    }

    public static final String createId(IIdAndCodeHolder identifiable) {
        return GenericExperimentViewer.createId(TechId.create(identifiable));
    }

    public static final String createId(TechId experimentId) {
        return ID_PREFIX + experimentId;
    }

    @Override
    public void updateOriginalData(Experiment newData) {
        super.updateOriginalData(newData);
    }

    private AttachmentVersionsSection createAttachmentsSection() {
        IAttachmentHolder attachmentHolder = GenericExperimentViewer.asExperimentAttachmentHolder(this.experimentId);
        return new AttachmentVersionsSection(this.localViewContext.getCommonViewContext(), attachmentHolder);
    }

    private static IAttachmentHolder asExperimentAttachmentHolder(final IIdAndCodeHolder identifiable) {
        return new IAttachmentHolder(){

            @Override
            public AttachmentHolderKind getAttachmentHolderKind() {
                return AttachmentHolderKind.EXPERIMENT;
            }

            @Override
            public Long getId() {
                return identifiable.getId();
            }

            @Override
            public String getCode() {
                return identifiable.getCode();
            }
        };
    }

    private List<DisposableTabContent> createRightPanel() {
        ArrayList<DisposableTabContent> allPanels = new ArrayList<DisposableTabContent>();
        allPanels.addAll(this.createAdditionalBrowserSectionPanels());
        DisposableTabContent sampleSection = this.createExperimentSampleSection();
        allPanels.add(sampleSection);
        DisposableTabContent dataSection = this.createExperimentDataSetSection();
        dataSection.setIds(DisplayTypeIDGenerator.DATA_SETS_SECTION);
        allPanels.add(dataSection);
        allPanels.add(EntityHistoryGrid.createPropertiesHistorySection(this.localViewContext, EntityKind.EXPERIMENT, new TechId(this.experimentId)));
        AttachmentVersionsSection attachmentsSection = this.createAttachmentsSection();
        allPanels.add(attachmentsSection);
        return allPanels;
    }

    protected DisposableTabContent createExperimentSampleSection() {
        return new ExperimentSamplesSection(this.localViewContext, this.localViewContext.getMessage("experiment_samples_selction_title", new Object[0]), this.experimentType, this.experimentId);
    }

    private DisposableTabContent createExperimentDataSetSection() {
        return new AbstractEntityDataSetsSection(this.localViewContext, new TechId(this.experimentId), this.experimentType){

            @Override
            protected IDisposableComponent createDataSetBrowser(BasicEntityType type, TechId entityID, IDirectlyConnectedController directlyConnectedController) {
                return ExperimentDataSetBrowser.create(this.viewContext, new TechId(GenericExperimentViewer.this.experimentId), GenericExperimentViewer.this.experimentType, directlyConnectedController);
            }
        };
    }

    private SectionsPanel layoutSections(List<DisposableTabContent> allPanels) {
        SectionsPanel container = new SectionsPanel(this.localViewContext.getCommonViewContext(), ID_PREFIX + this.experimentId);
        container.setDisplayID(DisplayTypeIDGenerator.GENERIC_EXPERIMENT_VIEWER, this.displayIdSuffix);
        for (DisposableTabContent panel : allPanels) {
            container.addSection(panel);
        }
        container.layout();
        return container;
    }

    protected List<DisposableTabContent> createAdditionalBrowserSectionPanels() {
        return Collections.emptyList();
    }

    private IDatabaseModificationObserver createModificationObserver() {
        if (this.propertiesPanelOrNull != null) {
            assert (this.rightPanelSectionsOrNull != null) : "right panel not layouted";
            CompositeDatabaseModificationObserverWithMainObserver modificationObserver = new CompositeDatabaseModificationObserverWithMainObserver(this.propertiesPanelOrNull.getDatabaseModificationObserver());
            for (DisposableTabContent panel : this.rightPanelSectionsOrNull) {
                modificationObserver.addObserver(panel.tryGetDatabaseModificationObserver());
            }
            return modificationObserver;
        }
        return new CompositeDatabaseModificationObserver();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.createModificationObserver().getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.createModificationObserver().update(observedModifications);
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.localViewContext.getMessage("button_delete_experiment", new Object[0]);
    }
}

