/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.MaterialReplicaSummaryComponent;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.utils.MaterialComponentUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ui.columns.specific.ScreeningLinkExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class MaterialReplicaSummaryViewer {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final boolean restrictGlobalScopeLinkToProject;
    private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;

    public static void openTab(IViewContext<IScreeningClientServiceAsync> screeningViewContext, String experimentPermId, boolean restrictGlobalScopeLinkToProject, MaterialIdentifier materialIdentifier, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        MaterialReplicaSummaryViewer viewer = new MaterialReplicaSummaryViewer(screeningViewContext, restrictGlobalScopeLinkToProject, analysisProcedureCriteria);
        AbstractAsyncCallback<Experiment> experimentFoundCallback = viewer.createExperimentFoundCallback(materialIdentifier);
        viewer.fetchExperimentByPermId(experimentPermId, experimentFoundCallback);
    }

    private MaterialReplicaSummaryViewer(IViewContext<IScreeningClientServiceAsync> screeningViewContext, boolean restrictGlobalScopeLinkToProject, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        this.screeningViewContext = screeningViewContext;
        this.restrictGlobalScopeLinkToProject = restrictGlobalScopeLinkToProject;
        this.analysisProcedureCriteria = analysisProcedureCriteria;
    }

    private void fetchExperimentByPermId(String experimentPermId, AbstractAsyncCallback<Experiment> experimentFoundCallback) {
        this.screeningViewContext.getCommonService().getExperimentInfoByPermId(experimentPermId, experimentFoundCallback);
    }

    private AbstractAsyncCallback<Experiment> createExperimentFoundCallback(final MaterialIdentifier materialIdentifier) {
        return new AbstractAsyncCallback<Experiment>(this.screeningViewContext){

            @Override
            protected void process(Experiment experiment) {
                this.viewContext.getCommonService().getMaterialInformationHolder(materialIdentifier, new MaterialFoundCallback(experiment));
            }
        };
    }

    private void openTab(Experiment experiment, Material material) {
        AbstractTabItemFactory factory = this.createTabFactory(experiment, material);
        DispatcherHelper.dispatchNaviEvent(factory);
    }

    private AbstractTabItemFactory createTabFactory(final Experiment experiment, final Material material) {
        return new AbstractTabItemFactory(){

            @Override
            public String getId() {
                return "openbis_-screening-MATERIAL_REPLICA_SUMMARY" + experiment.getPermId() + "-" + material.getPermId();
            }

            @Override
            public ITabItem create() {
                IDisposableComponent tabComponent = MaterialReplicaSummaryComponent.createViewer((IViewContext<IScreeningClientServiceAsync>)MaterialReplicaSummaryViewer.this.screeningViewContext, experiment, material, MaterialReplicaSummaryViewer.this.restrictGlobalScopeLinkToProject, MaterialReplicaSummaryViewer.this.analysisProcedureCriteria);
                return DefaultTabItem.create(this.getTabTitle(), tabComponent, MaterialReplicaSummaryViewer.this.screeningViewContext);
            }

            @Override
            public String tryGetLink() {
                WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = WellSearchCriteria.ExperimentSearchCriteria.createExperiment(experiment, MaterialReplicaSummaryViewer.this.restrictGlobalScopeLinkToProject);
                return ScreeningLinkExtractor.createMaterialDetailsLink((IEntityInformationHolder)material, experimentCriteria);
            }

            @Override
            public String getTabTitle() {
                return String.valueOf(MaterialComponentUtils.getMaterialName(material)) + " in " + experiment.getCode() + " Summary";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return null;
            }
        };
    }

    private class MaterialFoundCallback
    extends AbstractAsyncCallback<IEntityInformationHolderWithPermId> {
        private final Experiment experiment;

        MaterialFoundCallback(Experiment experiment) {
            super(MaterialReplicaSummaryViewer.this.screeningViewContext);
            this.experiment = experiment;
        }

        @Override
        protected void process(IEntityInformationHolderWithPermId material) {
            ((IScreeningClientServiceAsync)MaterialReplicaSummaryViewer.this.screeningViewContext.getService()).getMaterialInfo(new TechId(material), (AsyncCallback<Material>)new AbstractAsyncCallback<Material>(MaterialReplicaSummaryViewer.this.screeningViewContext){

                @Override
                protected void process(Material result) {
                    MaterialReplicaSummaryViewer.this.openTab(MaterialFoundCallback.this.experiment, result);
                }
            });
        }
    }
}

