/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools;

import ch.systemsx.cisd.openbis.generic.shared.util.MaterialConfigurationProvider;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.PlateImageAnalysisColumnExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.PlateWellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.server.library_tools.QiagenScreeningLibraryColumnExtractor;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ImageAnalysisGeneMerger {
    private static final char SEPARATOR = ',';
    private static final String GENE_SYMBOL = "gene";
    private static final String GENE_DESCRIPTION = "description";

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            ImageAnalysisGeneMerger.error("Invalid parameters. Expected: <library-file-path> <image-analysis-folder> <output-folder>");
        }
        CsvReader libraryReader = ImageAnalysisGeneMerger.readFile(new File(args[0]));
        File analysisFolder = new File(args[1]);
        File outputFolder = new File(args[2]);
        Map<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails> geneMap = ImageAnalysisGeneMerger.readGeneMap(libraryReader);
        libraryReader.close();
        ImageAnalysisGeneMerger.mergeAnalysisDirWithGenes(analysisFolder, outputFolder, geneMap);
    }

    private static void mergeAnalysisDirWithGenes(File analysisFolder, File outputFolder, Map<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails> geneMap) throws Exception {
        outputFolder.mkdirs();
        File[] fileArray = analysisFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File plateAnalysisFile = fileArray[n2];
            File outFile = new File(outputFolder, plateAnalysisFile.getName());
            ImageAnalysisGeneMerger.mergeAnalysisFileWithGenes(plateAnalysisFile, outFile, geneMap);
            ++n2;
        }
    }

    private static void mergeAnalysisFileWithGenes(File plateAnalysisFile, File outFile, Map<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails> geneMap) throws Exception {
        CsvReader reader = ImageAnalysisGeneMerger.readFile(plateAnalysisFile);
        boolean headerPresent = reader.readRecord();
        if (!headerPresent) {
            throw ImageAnalysisGeneMerger.error("header not found");
        }
        String orgHeaders = reader.getRawRecord();
        PlateImageAnalysisColumnExtractor extractor = new PlateImageAnalysisColumnExtractor(reader.getValues());
        FileOutputStream out = new FileOutputStream(outFile);
        ImageAnalysisGeneMerger.writeLine(ImageAnalysisGeneMerger.createHeader(orgHeaders), out);
        while (reader.readRecord()) {
            String[] row = reader.getValues();
            PlateWellLocation loc = extractor.getPlateWellLocation(row);
            QiagenScreeningLibraryColumnExtractor.GeneDetails gene = geneMap.get(loc);
            String resultLine = ImageAnalysisGeneMerger.createLine(reader.getRawRecord(), gene);
            ImageAnalysisGeneMerger.writeLine(resultLine, out);
        }
        ((OutputStream)out).close();
    }

    private static void writeLine(String line, OutputStream out) throws IOException {
        IOUtils.writeLines(Arrays.asList(line), (String)"\n", (OutputStream)out);
    }

    private static String createHeader(String originalLine) {
        return String.valueOf(originalLine) + ',' + GENE_SYMBOL + ',' + GENE_DESCRIPTION;
    }

    private static String createLine(String originalLine, QiagenScreeningLibraryColumnExtractor.GeneDetails geneOrNull) {
        return String.valueOf(originalLine) + ',' + (geneOrNull == null ? "" : geneOrNull.getSymbol()) + ',' + (geneOrNull == null ? "" : ImageAnalysisGeneMerger.quote(geneOrNull.getDescription()));
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }

    private static Map<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails> readGeneMap(CsvReader libraryReader) throws Exception {
        HashMap<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails> map = new HashMap<PlateWellLocation, QiagenScreeningLibraryColumnExtractor.GeneDetails>();
        boolean headerPresent = libraryReader.readRecord();
        if (!headerPresent) {
            throw ImageAnalysisGeneMerger.error("header not found");
        }
        String[] headers = libraryReader.getValues();
        QiagenScreeningLibraryColumnExtractor extractor = new QiagenScreeningLibraryColumnExtractor(headers, MaterialConfigurationProvider.getInstance());
        while (libraryReader.readRecord()) {
            String[] row = libraryReader.getValues();
            PlateWellLocation loc = extractor.getPlateWellLocation(row);
            QiagenScreeningLibraryColumnExtractor.GeneDetails gene = extractor.getGeneDetails(row);
            map.put(loc, gene);
        }
        return map;
    }

    static CsvReader readFile(File file) throws FileNotFoundException, IOException {
        if (!file.isFile()) {
            ImageAnalysisGeneMerger.error(file + " does not exist or is not a file.");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        CsvReader csvReader = new CsvReader((InputStream)fileInputStream, Charset.defaultCharset());
        csvReader.setDelimiter(',');
        csvReader.setSafetySwitch(false);
        return csvReader;
    }

    private static Exception error(String msg) {
        System.err.println(msg);
        System.exit(1);
        return new Exception();
    }
}

