/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import java.util.List;

public class ExperimentIdentifierPredicate
extends AbstractSpacePredicate<ExperimentIdentifier> {
    @Override
    public String getCandidateDescription() {
        return "experiment";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentIdentifier value) {
        if (value.getPermId() != null) {
            ExperimentPE experimentOrNull = this.authorizationDataProvider.tryGetExperimentByPermId(value.getPermId());
            if (experimentOrNull == null) {
                return Status.createError(String.format("User '%s' does not have enough privileges.", person.getUserId()));
            }
            SpacePE space = experimentOrNull.getProject().getSpace();
            return this.evaluate(person, allowedRoles, space.getDatabaseInstance(), space.getCode());
        }
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, value.getSpaceCode());
        return this.evaluate(person, allowedRoles, this.authorizationDataProvider.getHomeDatabaseInstance(), spaceCode);
    }
}

