/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.List;

public class PlateIdentifierPredicate
extends AbstractSpacePredicate<PlateIdentifier> {
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate;

    public PlateIdentifierPredicate() {
        this(true);
    }

    public PlateIdentifierPredicate(boolean isReadAccess) {
        this.sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleOwnerIdentifierPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "plate identifier";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, PlateIdentifier value) {
        SampleIdentifier plateOwner;
        if (value.getPermId() != null) {
            SamplePE sample = this.authorizationDataProvider.tryGetSampleByPermId(value.getPermId());
            if (sample == null) {
                return Status.createError(String.format("User '%s' does not have enough privileges.", person.getUserId()));
            }
            plateOwner = sample.getSampleIdentifier();
        } else {
            plateOwner = SampleIdentifierFactory.parse(value.getAugmentedCode());
        }
        return this.performSampleOwnerPredicateEvaluation(person, allowedRoles, plateOwner);
    }

    private Status performSampleOwnerPredicateEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleOwnerIdentifier sampleOwner) {
        return this.sampleOwnerIdentifierPredicate.performEvaluation(person, allowedRoles, sampleOwner);
    }
}

