/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.authorization;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.exception.UndefinedSpaceException;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

@ShouldFlattenCollections(value=false)
public class ScreeningPlateListReadOnlyPredicate
extends AbstractSpacePredicate<List<? extends PlateIdentifier>> {
    private static final int ARRAY_SIZE_LIMIT = 999;
    private final ISampleToSpaceQuery sampleToSpaceQuery = (ISampleToSpaceQuery)QueryTool.getManagedQuery(ISampleToSpaceQuery.class);

    @Override
    public String getCandidateDescription() {
        return "plate";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<? extends PlateIdentifier> plates) {
        ArrayList<String> permIds = new ArrayList<String>(plates.size());
        for (PlateIdentifier plateIdentifier : plates) {
            Status status;
            String spaceCodeOrNull;
            boolean hasPermId = false;
            if (plateIdentifier.getPermId() != null) {
                permIds.add(plateIdentifier.getPermId());
                hasPermId = true;
            }
            if ((spaceCodeOrNull = SpaceCodeHelper.tryGetSpaceCode(person, plateIdentifier.tryGetSpaceCode())) == null && !hasPermId) {
                throw new UndefinedSpaceException();
            }
            if (spaceCodeOrNull == null || plateIdentifier.isSharedPlate() || Status.OK.equals(status = this.evaluate(person, allowedRoles, this.authorizationDataProvider.getHomeDatabaseInstance(), spaceCodeOrNull))) continue;
            return status;
        }
        if (!permIds.isEmpty()) {
            for (Long l : this.getSampleSpaceIds(permIds)) {
                Status status;
                if (l == null || Status.OK.equals(status = this.evaluate(person, allowedRoles, l))) continue;
                return status;
            }
        }
        return Status.OK;
    }

    private Collection<Long> getSampleSpaceIds(List<String> permIds) {
        if (permIds.size() > 999) {
            HashSet<Long> spaceIds = new HashSet<Long>(permIds.size());
            int startIdx = 0;
            while (startIdx < permIds.size()) {
                List<String> permIdSubList = permIds.subList(startIdx, Math.min(permIds.size(), startIdx + 999));
                spaceIds.addAll(this.sampleToSpaceQuery.getSampleSpaceIds(permIdSubList.toArray(new String[permIdSubList.size()])));
                startIdx += 999;
            }
            return spaceIds;
        }
        return this.sampleToSpaceQuery.getSampleSpaceIds(permIds.toArray(new String[permIds.size()]));
    }

    static interface ISampleToSpaceQuery
    extends BaseQuery {
        @Select(sql="select distinct space_id from samples where perm_id = any(?{1})", parameterBindings={StringArrayMapper.class})
        public List<Long> getSampleSpaceIds(String[] var1);
    }
}

