/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.PlateDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class HCSImageDatasetLoader
extends PlateDatasetLoader {
    protected static Collection<Long> extractIds(List<AbstractExternalData> datasets) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (AbstractExternalData dataset : datasets) {
            ids.add(dataset.getId());
        }
        return ids;
    }

    private static Map<Long, AbstractExternalData> createChildToParentDataSetsMap(Map<Long, Set<Long>> childIdToParentIdsMap, List<AbstractExternalData> parentDatasets) {
        HashMap<Long, AbstractExternalData> childDataSetToParentDataSetsMap = new HashMap<Long, AbstractExternalData>();
        for (Map.Entry<Long, Set<Long>> entry : childIdToParentIdsMap.entrySet()) {
            List<AbstractExternalData> parents = HCSImageDatasetLoader.findDatasetsWithIds(entry.getValue(), parentDatasets);
            if (parents.size() != 1) continue;
            Long childId = entry.getKey();
            childDataSetToParentDataSetsMap.put(childId, parents.get(0));
        }
        return childDataSetToParentDataSetsMap;
    }

    private static List<AbstractExternalData> findDatasetsWithIds(Set<Long> datasetIds, List<AbstractExternalData> datasets) {
        ArrayList<AbstractExternalData> found = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : datasets) {
            if (!datasetIds.contains(dataset.getId())) continue;
            found.add(dataset);
        }
        return found;
    }

    HCSImageDatasetLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String homeSpaceOrNull, Set<? extends PlateIdentifier> plates, String ... datasetTypeCodes) {
        String[] stringArray;
        if (datasetTypeCodes.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)";
        } else {
            stringArray = datasetTypeCodes;
        }
        super(session, businessObjectFactory, homeSpaceOrNull, plates, stringArray);
    }

    public List<AbstractExternalData> getImageDatasets() {
        this.load();
        return this.filterImageDatasets();
    }

    private List<AbstractExternalData> getRawImageDatasets() {
        this.load();
        return this.filterRawImageDatasets();
    }

    private List<AbstractExternalData> getSegmentationImageDatasets() {
        this.load();
        ArrayList<AbstractExternalData> imageDatasets = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : this.getDatasets()) {
            if (!ScreeningUtils.isBasicHcsImageDataset(dataset)) continue;
            imageDatasets.add(dataset);
        }
        return this.fetchChildrenDataSets(imageDatasets, "HCS_IMAGE.*OVERLAY.*|HCS_IMAGE.*_SEGMENTATION.*", this.createDatasetLister());
    }

    public List<ImageDatasetReference> getImageDatasetReferences() {
        return this.asImageDatasetReferences(this.getImageDatasets());
    }

    public List<ImageDatasetReference> getRawImageDatasetReferences() {
        return this.asImageDatasetReferences(this.getRawImageDatasets());
    }

    public List<ImageDatasetReference> getSegmentationImageDatasetReferences() {
        return this.asImageDatasetReferences(this.getSegmentationImageDatasets());
    }

    private List<AbstractExternalData> filterImageDatasets() {
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData externalData : this.getDatasets()) {
            if (!ScreeningUtils.isBasicHcsImageDataset(externalData) || externalData.tryGetContainer() != null) continue;
            result.add(externalData);
        }
        return result;
    }

    private List<AbstractExternalData> filterRawImageDatasets() {
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData externalData : this.getDatasets()) {
            if (!ScreeningUtils.isRawHcsImageDataset(externalData)) continue;
            result.add(externalData);
        }
        return result;
    }

    private List<ImageDatasetReference> asImageDatasetReferences(List<AbstractExternalData> imageDatasets) {
        ArrayList<ImageDatasetReference> references = new ArrayList<ImageDatasetReference>();
        for (AbstractExternalData imageDataset : imageDatasets) {
            ImageDatasetReference reference = this.tryAsImageDataset(imageDataset);
            if (reference == null) continue;
            references.add(reference);
        }
        return references;
    }

    protected void enrichWithParentDatasets(Collection<AbstractExternalData> childrenDataSets, List<AbstractExternalData> parentDataSets, String childTypePattern, IDatasetLister datasetLister) {
        Map<Long, AbstractExternalData> childIdToParentDataSetMap = this.createChildToParentDataSetsMap(parentDataSets, childTypePattern, datasetLister);
        this.enrichWithParentDatasets(childrenDataSets, childIdToParentDataSetMap);
    }

    private void enrichWithParentDatasets(Collection<AbstractExternalData> childrenDataSets, Map<Long, AbstractExternalData> childIdToParentDataSetMap) {
        for (AbstractExternalData child : childrenDataSets) {
            AbstractExternalData parentImageDataset = childIdToParentDataSetMap.get(child.getId());
            if (parentImageDataset == null) continue;
            child.setParents(Arrays.asList(parentImageDataset));
        }
    }

    private Map<Long, AbstractExternalData> createChildToParentDataSetsMap(List<AbstractExternalData> parentDataSets, String childTypePattern, IDatasetLister datasetLister) {
        List<AbstractExternalData> filteredChildrenForParents = this.listFilteredChildrenDataSets(parentDataSets, childTypePattern, datasetLister);
        return this.createChildToParentDataSetsMap(filteredChildrenForParents, parentDataSets, datasetLister);
    }

    protected List<AbstractExternalData> fetchChildrenDataSets(List<AbstractExternalData> parentDataSets, String childTypePattern, IDatasetLister datasetLister) {
        List<AbstractExternalData> filteredChildrenForParents = this.listFilteredChildrenDataSets(parentDataSets, childTypePattern, datasetLister);
        Map<Long, AbstractExternalData> childIdToParentDataSetsMap = this.createChildToParentDataSetsMap(filteredChildrenForParents, parentDataSets, datasetLister);
        HCSImageDatasetLoader.setParentDatasets(filteredChildrenForParents, childIdToParentDataSetsMap);
        return filteredChildrenForParents;
    }

    private static void setParentDatasets(List<AbstractExternalData> childrenDatasets, Map<Long, AbstractExternalData> childIdToParentDataSetsMap) {
        for (AbstractExternalData child : childrenDatasets) {
            AbstractExternalData parentImageDataset = childIdToParentDataSetsMap.get(child.getId());
            if (parentImageDataset == null) continue;
            child.setParents(Arrays.asList(parentImageDataset));
        }
    }

    private Map<Long, AbstractExternalData> createChildToParentDataSetsMap(List<AbstractExternalData> childrenDataSets, List<AbstractExternalData> parentDataSets, IDatasetLister datasetLister) {
        Collection<Long> childrenIds = HCSImageDatasetLoader.extractIds(childrenDataSets);
        Map<Long, Set<Long>> childIdToParentIdsMap = datasetLister.listParentIds(childrenIds);
        return HCSImageDatasetLoader.createChildToParentDataSetsMap(childIdToParentIdsMap, parentDataSets);
    }

    protected IDatasetLister createDatasetLister() {
        return this.businessObjectFactory.createDatasetLister(this.session);
    }

    private List<AbstractExternalData> listFilteredChildrenDataSets(List<AbstractExternalData> parentDataSets, String childTypePattern, IDatasetLister datasetLister) {
        return ScreeningUtils.filterExternalDataByTypePattern(datasetLister.listByParentTechIds(HCSImageDatasetLoader.extractIds(parentDataSets)), childTypePattern);
    }

    private AbstractExternalData tryGetParent(AbstractExternalData externalData) {
        if (externalData.getParents() != null && externalData.getParents().size() == 1) {
            return externalData.getParents().iterator().next();
        }
        return null;
    }

    protected ImageDatasetReference tryAsImageDataset(AbstractExternalData externalData) {
        if (externalData == null || !ScreeningUtils.isHcsImageDataset(externalData)) {
            return null;
        }
        DataStore dataStore = externalData.getDataStore();
        DataSetType dataSetType = externalData.getDataSetType();
        String dataSetTypeCodeOrNull = dataSetType == null ? null : dataSetType.getCode();
        return new ImageDatasetReference(externalData.getCode(), dataSetTypeCodeOrNull, HCSImageDatasetLoader.getDataStoreUrlFromDataStore(dataStore), this.createPlateIdentifier(externalData), HCSImageDatasetLoader.createExperimentIdentifier(externalData), this.extractPlateGeometry(externalData), externalData.getRegistrationDate(), this.extractProperties(externalData), this.tryAsImageDataset(this.tryGetParent(externalData)));
    }
}

