/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.xml.XMLInfraStructure;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinProphetDetails;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ProteinSummary;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ProtXMLLoader {
    private final Unmarshaller unmarshaller;
    private final XMLInfraStructure xmlInfraStructure;

    ProtXMLLoader(boolean validating) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProteinSummary.class, ProteinProphetDetails.class});
            this.unmarshaller = context.createUnmarshaller();
            this.xmlInfraStructure = new XMLInfraStructure(validating);
            this.xmlInfraStructure.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    String schemaVersion = systemId.substring(systemId.lastIndexOf(47));
                    String resource = "/" + ProtXMLLoader.class.getPackage().getName().replace('.', '/') + schemaVersion;
                    InputStream inputStream = ProtXMLLoader.class.getResourceAsStream(resource);
                    return inputStream == null ? null : new InputSource(inputStream);
                }
            });
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    ProteinSummary readProtXML(File dataSet) {
        try {
            UnmarshallerHandler unmarshallerHandler = this.unmarshaller.getUnmarshallerHandler();
            this.xmlInfraStructure.parse((Reader)new FileReader(dataSet), (ContentHandler)unmarshallerHandler);
            Object object = unmarshallerHandler.getResult();
            if (!(object instanceof ProteinSummary)) {
                throw new IllegalArgumentException("Wrong type: " + object);
            }
            return (ProteinSummary)object;
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

