/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.AbstractThumbnailsConfiguration;

public class ZoomLevelBasedThumbnailsConfiguration
extends AbstractThumbnailsConfiguration {
    private final double zoomLevel;

    public ZoomLevelBasedThumbnailsConfiguration(double zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @Override
    public ThumbnailsStorageFormat getThumbnailsStorageFormat(SimpleImageDataConfig config) {
        ThumbnailsStorageFormat thumbnailsStorageFormat = super.getThumbnailsStorageFormat(config);
        thumbnailsStorageFormat.setZoomLevel(this.zoomLevel);
        return thumbnailsStorageFormat;
    }

    @Override
    protected String getDefaultFileName() {
        return String.format("thumbnails_%.0fpct%s.h5ar", this.zoomLevel * 100.0, this.getFirstTransformationCode());
    }
}

