/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.ICIFEXServiceAsync;
import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.UserWidget;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;

public class CreateUserWidget
extends UserWidget {
    public CreateUserWidget(ViewContext context, boolean addStatusField) {
        super(context, addStatusField);
    }

    @Override
    final boolean submitForm() {
        if (!this.arePasswordsEqual()) {
            return false;
        }
        if (this.isValid()) {
            if (this.buttonOrNull != null) {
                this.buttonOrNull.disable();
            }
            UserInfoDTO user = this.createFromFields();
            String comment = null;
            if (this.commentArea != null) {
                comment = (String)this.commentArea.getValue();
            }
            ICIFEXServiceAsync cifexService = this.context.getCifexService();
            cifexService.createUser(user, StringUtils.nullIfBlank((String)this.passwordField.getValue()), comment, new CreateUserAsyncCallBack());
            return true;
        }
        return false;
    }

    @Override
    final String getSubmitButtonLabel() {
        if (this.context.getModel().getUser().isAdmin()) {
            return MessageDictionary.msg(MessageDictionary.CREATE_USER_LABEL);
        }
        return MessageDictionary.msg(MessageDictionary.CREATE_TEMP_USER_LABEL);
    }

    private final class CreateUserAsyncCallBack
    extends AbstractAsyncCallback<UserInfoDTO> {
        CreateUserAsyncCallBack() {
            super(CreateUserWidget.this.context);
        }

        @Override
        public final void onFailure(Throwable caught) {
            super.onFailure(caught);
            if (CreateUserWidget.this.buttonOrNull != null) {
                CreateUserWidget.this.buttonOrNull.enable();
            }
        }

        public final void onSuccess(UserInfoDTO result) {
            CreateUserWidget.this.context.getPageController().refreshMainPage();
        }
    }
}

