/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.encryption;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.util.Strings;

public class PGPLiteralDataGenerator
implements Closeable {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    private void writeHeader(OutputStream out, char format, byte[] encodedName, long modificationTime) throws IOException {
        out.write(format);
        out.write((byte)encodedName.length);
        int i = 0;
        while (i != encodedName.length) {
            out.write(encodedName[i]);
            ++i;
        }
        long modDate = modificationTime / 1000L;
        out.write((byte)(modDate >> 24));
        out.write((byte)(modDate >> 16));
        out.write((byte)(modDate >> 8));
        out.write((byte)modDate);
    }

    public OutputStream open(OutputStream out, char format, String name, long length, Date modificationTime) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] encodedName = Strings.toUTF8ByteArray((String)name);
        this.pkOut = new BCPGOutputStream(out, 11, length + 2L + (long)encodedName.length + 4L, this.oldFormat);
        this.writeHeader((OutputStream)this.pkOut, format, encodedName, modificationTime.getTime());
        return new WrappedGeneratorStream((OutputStream)this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime, byte[] buffer) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(out, 11, buffer);
        byte[] encodedName = Strings.toUTF8ByteArray((String)name);
        this.writeHeader((OutputStream)this.pkOut, format, encodedName, modificationTime.getTime());
        return new WrappedGeneratorStream((OutputStream)this.pkOut, this);
    }

    public OutputStream open(OutputStream out, char format, File file) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] encodedName = Strings.toUTF8ByteArray((String)file.getName());
        this.pkOut = new BCPGOutputStream(out, 11, file.length() + 2L + (long)encodedName.length + 4L, this.oldFormat);
        this.writeHeader((OutputStream)this.pkOut, format, encodedName, file.lastModified());
        return new WrappedGeneratorStream((OutputStream)this.pkOut, this);
    }

    @Override
    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }

    static class WrappedGeneratorStream
    extends OutputStream {
        private final OutputStream _out;
        private final Closeable _sGen;

        public WrappedGeneratorStream(OutputStream out, Closeable sGen) {
            this._out = out;
            this._sGen = sGen;
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            this._out.write(bytes, offset, length);
        }

        @Override
        public void write(int b) throws IOException {
            this._out.write(b);
        }

        @Override
        public void flush() throws IOException {
            this._out.flush();
        }

        @Override
        public void close() throws IOException {
            this._sGen.close();
        }
    }
}

