/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.ldap;

import ch.systemsx.cisd.common.time.DateTimeUtils;
import org.apache.commons.lang.StringUtils;

public final class LDAPDirectoryConfiguration {
    static final String DEFAULT_QUERY_TEMPLATE = "(&(objectClass=organizationalPerson)(objectCategory=person)(objectClass=user)(%s))";
    private String userIdAttributeName = "uid";
    private String lastNameAttributeName = "sn";
    private String firstNameAttributeName = "givenName";
    private String emailAttributeName = "mail";
    private String emailAliasesAttributeName = "proxyAddresses";
    private String emailAttributePrefix = "smtp:";
    private String queryEmailForAliases = "false";
    private String securityProtocol = "ssl";
    private String securityAuthenticationMethod = "simple";
    private String referral = "follow";
    private long timeout = 10000L;
    private int maxRetries = 1;
    private long timeToWaitAfterFailure = 10000L;
    private String queryTemplate = "(&(objectClass=organizationalPerson)(objectCategory=person)(objectClass=user)(%s))";
    private String securityPrincipalDistinguishedName;
    private String serverUrl;
    private String securityPrincipalPassword;

    public boolean isConfigured() {
        return StringUtils.isNotBlank((String)this.serverUrl) && StringUtils.isNotBlank((String)this.securityPrincipalDistinguishedName) && StringUtils.isNotBlank((String)this.securityPrincipalPassword);
    }

    public String getUserIdAttributeName() {
        return this.userIdAttributeName;
    }

    public void setUserIdAttributeName(String userIdAttributeName) {
        if (LDAPDirectoryConfiguration.isResolved(userIdAttributeName)) {
            this.userIdAttributeName = userIdAttributeName;
        }
    }

    public String getLastNameAttributeName() {
        return this.lastNameAttributeName;
    }

    public void setLastNameAttributeName(String lastNameAttributeName) {
        if (LDAPDirectoryConfiguration.isResolved(lastNameAttributeName)) {
            this.lastNameAttributeName = lastNameAttributeName;
        }
    }

    public String getFirstNameAttributeName() {
        return this.firstNameAttributeName;
    }

    public void setFirstNameAttributeName(String firstNameAttributeName) {
        if (LDAPDirectoryConfiguration.isResolved(firstNameAttributeName)) {
            this.firstNameAttributeName = firstNameAttributeName;
        }
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public void setEmailAttributeName(String emailAttributeName) {
        if (LDAPDirectoryConfiguration.isResolved(emailAttributeName)) {
            this.emailAttributeName = emailAttributeName;
        }
    }

    public String getEmailAliasesAttributeName() {
        return this.emailAliasesAttributeName;
    }

    public void setEmailAliasesAttributeName(String emailAliasesAttributeName) {
        if (LDAPDirectoryConfiguration.isResolved(emailAliasesAttributeName)) {
            this.emailAliasesAttributeName = emailAliasesAttributeName;
        }
    }

    public String getQueryEmailForAliases() {
        return this.queryEmailForAliases;
    }

    public void setQueryEmailForAliases(String queryEmailForAliases) {
        if (LDAPDirectoryConfiguration.isResolved(queryEmailForAliases)) {
            this.queryEmailForAliases = queryEmailForAliases;
        }
    }

    public String getEmailAttributePrefix() {
        return this.emailAttributePrefix;
    }

    public void setEmailAttributePrefix(String emailAttributePrefix) {
        if (LDAPDirectoryConfiguration.isResolved(emailAttributePrefix)) {
            this.emailAttributePrefix = emailAttributePrefix;
        }
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        if (LDAPDirectoryConfiguration.isResolved(securityProtocol)) {
            this.securityProtocol = securityProtocol;
        }
    }

    public String getSecurityPrincipalDistinguishedName() {
        return this.securityPrincipalDistinguishedName;
    }

    public void setSecurityPrincipalDistinguishedName(String securityPrincipal) {
        this.securityPrincipalDistinguishedName = securityPrincipal;
    }

    public String getSecurityPrincipalPassword() {
        return this.securityPrincipalPassword;
    }

    public void setSecurityPrincipalPassword(String password) {
        this.securityPrincipalPassword = password;
    }

    public String getSecurityAuthenticationMethod() {
        return this.securityAuthenticationMethod;
    }

    public void setSecurityAuthenticationMethod(String securityAuthenticationMethod) {
        if (LDAPDirectoryConfiguration.isResolved(securityAuthenticationMethod)) {
            this.securityAuthenticationMethod = securityAuthenticationMethod;
        }
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String referral) {
        if (LDAPDirectoryConfiguration.isResolved(referral)) {
            this.referral = referral;
        }
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String queryTemplate) {
        if (LDAPDirectoryConfiguration.isResolved(queryTemplate)) {
            this.queryTemplate = queryTemplate;
        }
    }

    public String getTimeoutStr() {
        return Long.toString(this.timeout / 1000L);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeoutStr(String timeoutStr) {
        if (LDAPDirectoryConfiguration.isResolved(timeoutStr)) {
            this.timeout = DateTimeUtils.parseDurationToMillis(timeoutStr);
        }
    }

    public long getTimeToWaitAfterFailure() {
        return this.timeToWaitAfterFailure;
    }

    public String getTimeToWaitAfterFailureStr() {
        return Long.toString(this.timeToWaitAfterFailure / 1000L);
    }

    public void setTimeToWaitAfterFailureStr(String timeToWaitOnFailureStr) {
        if (LDAPDirectoryConfiguration.isResolved(timeToWaitOnFailureStr)) {
            this.timeToWaitAfterFailure = DateTimeUtils.parseDurationToMillis(timeToWaitOnFailureStr);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getMaxRetriesStr() {
        return Integer.toString(this.maxRetries);
    }

    public void setMaxRetriesStr(String maxRetries) {
        if (LDAPDirectoryConfiguration.isResolved(maxRetries)) {
            this.maxRetries = Integer.parseInt(maxRetries);
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String ldapUrl) {
        this.serverUrl = ldapUrl;
    }

    private static boolean isResolved(String name) {
        return StringUtils.isNotBlank((String)name) && !name.startsWith("${");
    }
}

