/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.MonitoringPoolingDataSource;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

public class MonitoringDataSource
extends BasicDataSource {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, MonitoringPoolingDataSource.class);
    private long activeConnectionsLogInterval;
    private int activeConnectionsLogThreshold;
    private long oldActiveConnectionTimeMillis;
    private boolean logStackTrace;

    public synchronized void setUrl(String url) {
        if (machineLog.isDebugEnabled()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            machineLog.debug((Object)("Creating data source '" + url + "'."), th);
        }
        super.setUrl(url);
    }

    public long getActiveConnectionsLogInterval() {
        return this.activeConnectionsLogInterval;
    }

    public void setActiveConnectionsLogInterval(long activeConnectionLogInterval) {
        this.activeConnectionsLogInterval = activeConnectionLogInterval;
    }

    public int getActiveConnectionsLogThreshold() {
        return this.activeConnectionsLogThreshold;
    }

    public void setActiveConnectionsLogThreshold(int activeConnectionsLogThreshold) {
        this.activeConnectionsLogThreshold = activeConnectionsLogThreshold;
    }

    public boolean isLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public long getOldActiveConnectionTimeMillis() {
        return this.oldActiveConnectionTimeMillis;
    }

    public void setOldActiveConnectionTimeMillis(long oldActiveConnectionTimeMillis) {
        this.oldActiveConnectionTimeMillis = oldActiveConnectionTimeMillis;
    }

    protected void createDataSourceInstance() throws SQLException {
        MonitoringPoolingDataSource pds = new MonitoringPoolingDataSource((ObjectPool)this.connectionPool, this.activeConnectionsLogInterval, this.activeConnectionsLogThreshold, this.oldActiveConnectionTimeMillis, this.logStackTrace);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        pds.setLogWriter(this.logWriter);
        this.dataSource = pds;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public synchronized void close() throws SQLException {
        if (machineLog.isDebugEnabled()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            machineLog.debug((Object)("Closing data source '" + this.getUrl() + "'."), th);
        }
        super.close();
    }
}

