/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.etlserver.BaseDirectoryHolder;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithm;
import ch.systemsx.cisd.etlserver.FileRenamer;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DataSetRegistrationRollbacker {
    private final boolean stopped;
    private final DataSetRegistrationAlgorithm registrationAlgorithm;
    private final File incomingDataSetFile;
    private final Logger notificationLog;
    private final Logger operationLog;
    private final Throwable throwable;

    public DataSetRegistrationRollbacker(boolean stopped, DataSetRegistrationAlgorithm registrationAlgorithm, File incomingDataSetFile, Logger notificationLog, Logger operationLog, Throwable throwable) {
        this.stopped = stopped;
        this.registrationAlgorithm = registrationAlgorithm;
        this.incomingDataSetFile = incomingDataSetFile;
        this.notificationLog = notificationLog;
        this.operationLog = operationLog;
        this.throwable = throwable;
    }

    public void doRollback() throws Error {
        if (this.stopped) {
            Thread.interrupted();
            this.getOperationLog().warn((Object)String.format("Requested to stop registration of data set '%s'", this.registrationAlgorithm.getDataSetInformation()));
        } else {
            this.getNotificationLog().error((Object)String.format(this.registrationAlgorithm.getErrorMessageTemplate(), this.registrationAlgorithm.getDataSetInformation()), this.throwable);
        }
        if (this.throwable instanceof Error && !(this.throwable instanceof AssertionError)) {
            throw (Error)this.throwable;
        }
        IStorageProcessorTransactional.UnstoreDataAction action = this.registrationAlgorithm.rollbackStorageProcessor(this.throwable);
        if (!this.stopped) {
            if (action == IStorageProcessorTransactional.UnstoreDataAction.MOVE_TO_ERROR) {
                File baseDirectory = this.registrationAlgorithm.createBaseDirectory(TransferredDataSetHandler.ERROR_DATA_STRATEGY, this.registrationAlgorithm.getStoreRoot());
                this.registrationAlgorithm.setBaseDirectoryHolder(new BaseDirectoryHolder(TransferredDataSetHandler.ERROR_DATA_STRATEGY, baseDirectory, this.incomingDataSetFile));
                boolean moveInCaseOfErrorOk = FileRenamer.renameAndLog(this.incomingDataSetFile, this.registrationAlgorithm.getBaseDirectoryHolder().getTargetFile());
                this.writeThrowable();
                if (moveInCaseOfErrorOk) {
                    this.registrationAlgorithm.clean();
                }
            } else if (action == IStorageProcessorTransactional.UnstoreDataAction.DELETE) {
                FileUtilities.deleteRecursively(this.incomingDataSetFile, new Log4jSimpleLogger(TransferredDataSetHandler.operationLog));
            }
        }
    }

    private Logger getNotificationLog() {
        return this.notificationLog;
    }

    private Logger getOperationLog() {
        return this.operationLog;
    }

    protected final void writeThrowable() {
        block5: {
            String fileName = String.valueOf(this.incomingDataSetFile.getName()) + ".exception";
            File file = new File(this.registrationAlgorithm.getBaseDirectoryHolder().getTargetFile().getParentFile(), fileName);
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    this.throwable.printStackTrace(new PrintWriter(writer));
                }
                catch (IOException e) {
                    TransferredDataSetHandler.operationLog.warn((Object)String.format("Could not write out the exception '%s' in file '%s'.", fileName, file.getAbsolutePath()), (Throwable)e);
                    IOUtils.closeQuietly((Writer)writer);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

