/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FileScanner {
    private final Pattern pathRegex;

    public FileScanner(String pattern) {
        String patternAsRegEx = pattern.replace("$", "\\$");
        patternAsRegEx = patternAsRegEx.replace(".", "\\.");
        patternAsRegEx = patternAsRegEx.replace("**/", "(.+/){0,}");
        patternAsRegEx = patternAsRegEx.replace("*", "[^/]*");
        patternAsRegEx = patternAsRegEx.replace("?", ".");
        this.pathRegex = Pattern.compile("/" + patternAsRegEx);
    }

    public List<File> scan(File fileOrFolder) {
        ArrayList<File> files = new ArrayList<File>();
        int pathPrefixLength = fileOrFolder.toString().length();
        if (fileOrFolder.isFile()) {
            pathPrefixLength = fileOrFolder.getParent().toString().length();
        }
        this.gatherFiles(files, fileOrFolder, pathPrefixLength);
        return files;
    }

    private void gatherFiles(List<File> gatheredFiles, File fileOrFolder, int pathPrefixLength) {
        String fileName = fileOrFolder.toString().substring(pathPrefixLength);
        if (this.pathRegex.matcher(fileName).matches()) {
            gatheredFiles.add(fileOrFolder);
        }
        if (fileOrFolder.isDirectory()) {
            File[] files;
            File[] fileArray = files = fileOrFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.gatherFiles(gatheredFiles, file, pathPrefixLength);
                ++n2;
            }
        }
    }
}

