/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IDataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.ArrayList;
import java.util.List;

public class JythonBasedPluginUtils {
    static IDataSet createDataSet(final DatasetDescription description, final IHierarchicalContent content) {
        return new IDataSet(){

            @Override
            public IHierarchicalContent getContent() {
                return content;
            }

            @Override
            public int getSpeedHint() {
                return description.getSpeedHint();
            }

            @Override
            public String getSpaceCode() {
                return description.getSpaceCode();
            }

            @Override
            public String getSampleTypeCode() {
                return description.getSampleTypeCode();
            }

            @Override
            public String getSampleIdentifier() {
                return description.getSampleIdentifier();
            }

            @Override
            public String getSampleCode() {
                return description.getSampleCode();
            }

            @Override
            public String getProjectCode() {
                return description.getProjectCode();
            }

            @Override
            public String getMainDataSetPattern() {
                return description.getMainDataSetPattern();
            }

            @Override
            public String getMainDataSetPath() {
                return description.getMainDataSetPath();
            }

            @Override
            public String getInstanceCode() {
                return description.getInstanceCode();
            }

            @Override
            public String getExperimentTypeCode() {
                return description.getExperimentTypeCode();
            }

            @Override
            public String getExperimentIdentifier() {
                return description.getExperimentIdentifier();
            }

            @Override
            public String getExperimentCode() {
                return description.getExperimentCode();
            }

            @Override
            public String getDataSetTypeCode() {
                return description.getDataSetTypeCode();
            }

            @Override
            public String getDatabaseInstanceCode() {
                return description.getDatabaseInstanceCode();
            }

            @Override
            public Long getDataSetSize() {
                return description.getDataSetSize();
            }

            @Override
            public String getDataSetLocation() {
                return description.getDataSetLocation();
            }

            @Override
            public String getDataSetCode() {
                return description.getDataSetCode();
            }
        };
    }

    static List<IDataSet> convert(List<DatasetDescription> dataSets, IHierarchicalContentProvider contentProvider) {
        ArrayList<IDataSet> result = new ArrayList<IDataSet>();
        try {
            for (DatasetDescription dataSet : dataSets) {
                IHierarchicalContent content = contentProvider.asContent(dataSet.getDataSetCode());
                result.add(JythonBasedPluginUtils.createDataSet(dataSet, content));
            }
            return result;
        }
        catch (RuntimeException ex) {
            JythonBasedPluginUtils.closeContent(result);
            throw ex;
        }
    }

    static void closeContent(List<IDataSet> dataSets) {
        for (IDataSet dataSet : dataSets) {
            dataSet.getContent().close();
        }
    }
}

