/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ViewLocator {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String PARAMETER_SEPARATOR = "&";
    public static final String ACTION_PARAMETER = "action";
    public static final String ENTITY_PARAMETER = "entity";
    public static final String PERM_ID_PARAMETER = "permId";
    public static final String PERMLINK_ACTION = "VIEW";
    private static final String GWT_PARAMETER = "gwt.codesvr";
    private String actionOrNull;
    private String entityOrNull;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String historyToken;

    public ViewLocator(String historyToken) {
        this.historyToken = historyToken;
        this.initializeFromHistoryToken();
    }

    public String getHistoryToken() {
        return this.historyToken;
    }

    public String tryGetAction() {
        return this.actionOrNull;
    }

    public String tryGetEntity() {
        return this.entityOrNull;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isValid() {
        return this.actionOrNull != null;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    private void initializeFromHistoryToken() {
        if (StringUtils.isBlank(this.historyToken)) {
            return;
        }
        String[] params = this.historyToken.split(PARAMETER_SEPARATOR);
        int i = 0;
        while (i < params.length) {
            String paramValue;
            String[] paramPair = params[i].split(KEY_VALUE_SEPARATOR);
            String paramName = paramPair.length > 0 ? paramPair[0] : null;
            String string = paramValue = paramPair.length > 1 ? paramPair[1] : null;
            if (paramValue != null) {
                paramValue = StringEscapeUtils.unescapeHtml(paramValue.replaceAll("%2F", "/"));
            }
            if (!GWT_PARAMETER.equals(paramName)) {
                if (ACTION_PARAMETER.equalsIgnoreCase(paramName)) {
                    this.actionOrNull = paramValue;
                } else if (ENTITY_PARAMETER.equalsIgnoreCase(paramName)) {
                    this.entityOrNull = paramValue;
                } else if (PERM_ID_PARAMETER.equalsIgnoreCase(paramName)) {
                    if (this.actionOrNull == null) {
                        this.actionOrNull = PERMLINK_ACTION;
                    }
                    this.parameters.put(paramName, paramValue);
                } else {
                    this.parameters.put(paramName, paramValue);
                }
            }
            ++i;
        }
        if (this.entityOrNull != null && this.actionOrNull == null) {
            this.actionOrNull = PERMLINK_ACTION;
        }
    }
}

