/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISpaceBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISpaceUpdates;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.Collections;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public final class SpaceBO
extends AbstractBusinessObject
implements ISpaceBO {
    private SpacePE space;

    public SpaceBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public final void save() throws UserFailureException {
        assert (this.space != null) : "Space not defined";
        try {
            if (!this.space.getDatabaseInstance().isOriginalSource()) {
                throw new UserFailureException("Registration of space " + this.space + " on a non-home database is not allowed.");
            }
            this.getSpaceDAO().createSpace(this.space);
        }
        catch (DataAccessException e) {
            SpaceBO.throwException(e, "Space '" + IdentifierHelper.createGroupIdentifier(this.space) + "'");
        }
    }

    @Override
    public void update(ISpaceUpdates updates) {
        this.loadDataByTechId(TechId.create(updates));
        this.space.setDescription(updates.getDescription());
        this.validateAndSave();
    }

    private void validateAndSave() {
        this.getSpaceDAO().validateAndSaveUpdatedEntity(this.space);
    }

    @Override
    public final void define(String groupCode, String descriptionOrNull) throws UserFailureException {
        assert (groupCode != null) : "Unspecified space code.";
        this.space = new SpacePE();
        SpaceIdentifier groupIdentifier = new SpaceIdentifier(DatabaseInstanceIdentifier.HOME, groupCode);
        DatabaseInstancePE databaseInstance = SpaceIdentifierHelper.getDatabaseInstance(groupIdentifier, this);
        this.space.setDatabaseInstance(databaseInstance);
        this.space.setCode(groupIdentifier.getSpaceCode());
        this.space.setDescription(descriptionOrNull);
        this.space.setRegistrator(this.findPerson());
    }

    @Override
    public SpacePE getSpace() throws UserFailureException {
        return this.space;
    }

    @Override
    public void load(SpaceIdentifier spaceIdentifier) throws UserFailureException {
        this.space = SpaceIdentifierHelper.tryGetSpace(spaceIdentifier, this.session.tryGetPerson(), this);
        if (this.space == null) {
            throw new UserFailureException(String.format("Space '%s' does not exist.", spaceIdentifier));
        }
    }

    @Override
    public void loadDataByTechId(TechId spaceId) {
        try {
            this.space = (SpacePE)this.getSpaceDAO().getByTechId(spaceId);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public void deleteByTechId(TechId spaceId, String reason) throws UserFailureException {
        this.loadDataByTechId(spaceId);
        try {
            this.getSpaceDAO().delete(this.space);
            this.getEventDAO().persist(SpaceBO.createDeletionEvent(this.space, this.session.tryGetPerson(), reason));
        }
        catch (DataAccessException ex) {
            SpaceBO.throwException(ex, String.format("Space '%s'", this.space.getCode()));
        }
    }

    public static EventPE createDeletionEvent(SpacePE space, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.SPACE);
        event.setIdentifiers(Collections.singletonList(space.getCode()));
        event.setDescription(SpaceBO.getDeletionDescription(space));
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    private static String getDeletionDescription(SpacePE space) {
        return String.format("%s", space.getCode());
    }
}

