/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinByExperiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ProteinViewLocatorResolver
extends AbstractViewLocatorResolver {
    private static final String ACTION = "PROTEIN";
    private static final String EXPERIMENT_PERM_ID = "experimentPermId";
    private static final String PROTEIN_ID = "id";
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;

    public ProteinViewLocatorResolver(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        super(ACTION);
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(ViewLocator locator) throws UserFailureException {
        String experimentPermID = ProteinViewLocatorResolver.getMandatoryParameter(locator, EXPERIMENT_PERM_ID);
        final TechId proteinID = new TechId(new Long(ProteinViewLocatorResolver.getMandatoryParameter(locator, PROTEIN_ID)));
        this.viewContext.log("resolve protein " + proteinID + " for experiment " + experimentPermID);
        this.viewContext.getCommonService().getExperimentInfoByPermId(experimentPermID, (AsyncCallback<Experiment>)new AbstractAsyncCallback<Experiment>(this.viewContext){

            @Override
            protected void process(final Experiment experiment) {
                IPhosphoNetXClientServiceAsync service = (IPhosphoNetXClientServiceAsync)ProteinViewLocatorResolver.this.viewContext.getService();
                service.getProteinByExperiment(new TechId(experiment.getId()), proteinID, (AsyncCallback<ProteinByExperiment>)new AbstractAsyncCallback<ProteinByExperiment>(this.viewContext){

                    @Override
                    protected void process(ProteinByExperiment protein) {
                        AbstractTabItemFactory tabItemFactory = ProteinViewer.createTabItemFactory(ProteinViewLocatorResolver.this.viewContext, experiment, protein);
                        DispatcherHelper.dispatchNaviEvent(tabItemFactory);
                    }
                });
            }
        });
    }

    static String createLink(Experiment experiment, ProteinInfo entity) {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", ACTION);
        url.addParameter(EXPERIMENT_PERM_ID, experiment.getPermId());
        url.addParameter(PROTEIN_ID, Long.toString(entity.getId().getId()));
        return url.toStringWithoutDelimiterPrefix();
    }
}

