/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class ExperimentLoader {
    private final IDAOFactory daoFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public ExperimentLoader(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.daoFactory = daoFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    public void enrichWithExperiments(Collection<Sample> samples) {
        List list;
        LinkedHashMap<Long, ArrayList<Sample>> samplesByID = new LinkedHashMap<Long, ArrayList<Sample>>();
        for (Sample sample : samples) {
            Experiment experiment = sample.getExperiment();
            if (experiment == null) continue;
            Long id = experiment.getId();
            list = (ArrayList<Sample>)samplesByID.get(id);
            if (list == null) {
                list = new ArrayList<Sample>();
                samplesByID.put(id, (ArrayList<Sample>)list);
            }
            list.add(sample);
        }
        List<ExperimentPE> experiments = this.daoFactory.getExperimentDAO().listExperimentsWithProperties(samplesByID.keySet());
        for (ExperimentPE experiment : experiments) {
            Experiment e = ExperimentTranslator.translate(experiment, "", null, this.managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES);
            list = (List)samplesByID.get(experiment.getId());
            for (Sample sample : list) {
                sample.setExperiment(e);
            }
        }
    }
}

