/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.api.v1;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.api.retry.Retry;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.IDataSetFilter;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.IPlateImageHandler;
import ch.systemsx.cisd.openbis.plugin.screening.client.api.v1.ScreeningOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetImageRepresentationFormats;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentImageMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetWellReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorWithDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IFeatureVectorDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IImageRepresentationFormatSelectionCriterion;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageRepresentationFormat;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.LoadImageConfiguration;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellMaterialMapping;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateWellReferenceWithDatasets;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface IScreeningOpenbisServiceFacade {
    @Retry
    public String getSessionToken();

    public void logout();

    public void clearWellImageCache();

    @Retry
    public List<Plate> listPlates();

    @Retry
    public List<PlateMetadata> getPlateMetadataList(List<? extends PlateIdentifier> var1);

    @Retry
    public List<Plate> listPlates(ExperimentIdentifier var1);

    @Retry
    public List<Plate> listPlates(ExperimentIdentifier var1, String var2);

    @Retry
    public List<ExperimentIdentifier> listExperiments();

    @Retry
    public List<ExperimentIdentifier> listExperiments(String var1);

    @Retry
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(List<? extends PlateIdentifier> var1);

    @Retry
    public List<FeatureVectorDatasetReference> listFeatureVectorDatasets(List<? extends PlateIdentifier> var1, String var2);

    @Retry
    @Deprecated
    public List<ImageDatasetReference> listImageDatasets(List<? extends PlateIdentifier> var1);

    @Retry
    public List<ImageDatasetReference> listRawImageDatasets(List<? extends PlateIdentifier> var1);

    @Retry
    public List<ImageDatasetReference> listSegmentationImageDatasets(List<? extends PlateIdentifier> var1);

    @Retry
    public List<ImageDatasetReference> listSegmentationImageDatasets(List<? extends PlateIdentifier> var1, String var2);

    @Retry
    public List<PlateWellReferenceWithDatasets> listPlateWells(ExperimentIdentifier var1, MaterialIdentifier var2, boolean var3);

    @Retry
    public List<PlateWellReferenceWithDatasets> listPlateWells(MaterialIdentifier var1, boolean var2);

    @Retry
    public List<WellIdentifier> listPlateWells(PlateIdentifier var1);

    @Retry
    public Map<String, String> getWellProperties(WellIdentifier var1);

    public void updateWellProperties(WellIdentifier var1, Map<String, String> var2);

    @Deprecated
    @Retry
    public List<IDataSetDss> getDataSets(WellIdentifier var1, String var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<IDataSetDss> getDataSets(WellIdentifier var1, IDataSetFilter var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public IDataSetDss getDataSet(String var1) throws IllegalStateException, EnvironmentFailureException;

    public IDataSetDss putDataSet(WellIdentifier var1, File var2, NewDataSetMetadataDTO var3) throws IllegalStateException, EnvironmentFailureException, IOException;

    @Deprecated
    @Retry
    public List<IDataSetDss> getDataSets(PlateIdentifier var1, String var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<IDataSetDss> getDataSets(PlateIdentifier var1, IDataSetFilter var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<DataSet> getFullDataSets(PlateIdentifier var1, IDataSetFilter var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<IDataSetDss> getDataSets(ExperimentIdentifier var1, IDataSetFilter var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<DataSet> getFullDataSets(ExperimentIdentifier var1, IDataSetFilter var2) throws IllegalStateException, EnvironmentFailureException;

    @Retry
    public List<DataSet> getDataSetMetaData(List<String> var1) throws IllegalStateException, EnvironmentFailureException;

    public IDataSetDss putDataSet(PlateIdentifier var1, File var2, NewDataSetMetadataDTO var3) throws IllegalStateException, EnvironmentFailureException, IOException;

    public IDataSetDss putDataSet(ExperimentIdentifier var1, File var2, NewDataSetMetadataDTO var3) throws IllegalStateException, EnvironmentFailureException, IOException;

    @Retry
    public List<FeatureVectorDatasetWellReference> convertToFeatureVectorDatasetWellIdentifier(List<PlateWellReferenceWithDatasets> var1);

    @Retry
    public List<IDatasetIdentifier> getDatasetIdentifiers(List<String> var1);

    @Deprecated
    @Retry
    public List<String> listAvailableFeatureNames(List<? extends IFeatureVectorDatasetIdentifier> var1);

    @Retry
    public List<String> listAvailableFeatureCodes(List<? extends IFeatureVectorDatasetIdentifier> var1);

    @Retry
    public List<FeatureInformation> listAvailableFeatures(List<? extends IFeatureVectorDatasetIdentifier> var1);

    @Retry
    public List<String> getFeatureList(IFeatureVectorDatasetIdentifier var1, String var2);

    @Retry
    public List<FeatureVectorDataset> loadFeaturesForPlates(List<? extends PlateIdentifier> var1, List<String> var2);

    @Retry
    public List<FeatureVectorDataset> loadFeaturesForPlates(List<? extends PlateIdentifier> var1, List<String> var2, String var3);

    @Retry
    public List<FeatureVectorDataset> loadFeatures(List<FeatureVectorDatasetReference> var1, List<String> var2);

    @Retry
    public List<FeatureVectorWithDescription> loadFeaturesForDatasetWellReferences(List<FeatureVectorDatasetWellReference> var1, List<String> var2);

    @Deprecated
    @Retry
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(ExperimentIdentifier var1, MaterialIdentifier var2, List<String> var3);

    @Retry
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(ExperimentIdentifier var1, MaterialIdentifier var2, String var3, List<String> var4);

    @Deprecated
    @Retry
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(MaterialIdentifier var1, List<String> var2);

    @Retry
    public List<FeatureVectorWithDescription> loadFeaturesForPlateWells(MaterialIdentifier var1, String var2, List<String> var3);

    @Retry
    public List<WellPosition> convertToWellPositions(List<WellIdentifier> var1);

    @Retry
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference var1);

    @Retry
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference var1, List<String> var2, List<WellPosition> var3);

    @Retry
    public List<PlateImageReference> createPlateImageReferences(ImageDatasetReference var1, ImageDatasetMetadata var2, List<String> var3, List<WellPosition> var4);

    @Retry
    public List<PlateImageReference> createPlateImageReferences(IImageDatasetIdentifier var1, List<String> var2, List<WellPosition> var3);

    @Retry
    public List<PlateImageReference> createPlateImageReferences(IImageDatasetIdentifier var1, ImageDatasetMetadata var2, List<String> var3, List<WellPosition> var4);

    public void loadImages(List<PlateImageReference> var1, ScreeningOpenbisServiceFacade.IImageOutputStreamProvider var2) throws IOException;

    public void loadImages(List<PlateImageReference> var1, ScreeningOpenbisServiceFacade.IImageOutputStreamProvider var2, boolean var3) throws IOException;

    public void loadImages(List<PlateImageReference> var1, boolean var2, IPlateImageHandler var3) throws IOException;

    @Retry
    public List<byte[]> loadImages(IDatasetIdentifier var1, List<WellPosition> var2, String var3, ImageSize var4) throws IOException;

    public void loadImages(IDatasetIdentifier var1, List<WellPosition> var2, String var3, ImageSize var4, IPlateImageHandler var5) throws IOException;

    @Retry
    public byte[] loadImageWellCaching(PlateImageReference var1, ImageSize var2) throws IOException;

    public void loadImages(List<PlateImageReference> var1, ImageSize var2, IPlateImageHandler var3) throws IOException;

    public void loadImages(List<PlateImageReference> var1, LoadImageConfiguration var2, IPlateImageHandler var3) throws IOException;

    public void loadImages(List<PlateImageReference> var1, IPlateImageHandler var2, ImageRepresentationFormat var3) throws IOException;

    public void loadImages(List<PlateImageReference> var1, IPlateImageHandler var2, IImageRepresentationFormatSelectionCriterion ... var3) throws IOException;

    @Retry
    public byte[] loadThumbnailImageWellCaching(PlateImageReference var1) throws IOException;

    public void loadThumbnailImages(List<PlateImageReference> var1, IPlateImageHandler var2) throws IOException;

    public void loadThumbnailImages(List<PlateImageReference> var1, ScreeningOpenbisServiceFacade.IImageOutputStreamProvider var2) throws IOException;

    public void saveImageTransformerFactory(List<IDatasetIdentifier> var1, String var2, IImageTransformerFactory var3);

    @Retry
    public IImageTransformerFactory getImageTransformerFactoryOrNull(List<IDatasetIdentifier> var1, String var2);

    @Retry
    public ImageDatasetMetadata listImageMetadata(IImageDatasetIdentifier var1);

    @Retry
    public List<ImageDatasetMetadata> listImageMetadata(List<? extends IImageDatasetIdentifier> var1);

    @Retry
    public List<PlateWellMaterialMapping> listPlateMaterialMapping(List<? extends PlateIdentifier> var1, MaterialTypeIdentifier var2);

    @Retry
    public List<String> listAnalysisProcedures(ExperimentIdentifier var1);

    @Retry
    public ExperimentImageMetadata getExperimentImageMetadata(ExperimentIdentifier var1);

    @Retry
    public List<DatasetImageRepresentationFormats> listAvailableImageRepresentationFormats(List<? extends IDatasetIdentifier> var1);

    public void loadPhysicalThumbnails(List<PlateImageReference> var1, ImageRepresentationFormat var2, IPlateImageHandler var3) throws IOException;

    public void loadPhysicalThumbnails(List<PlateImageReference> var1, ImageRepresentationFormat var2, ScreeningOpenbisServiceFacade.IImageOutputStreamProvider var3) throws IOException;
}

