/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.AbstractViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.MaterialCodeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.WellSearchComponent;

public class GlobalWellSearchLocatorResolver
extends AbstractViewLocatorResolver {
    private final IViewContext<IScreeningClientServiceAsync> viewContext;

    public GlobalWellSearchLocatorResolver(IViewContext<IScreeningClientServiceAsync> viewContext) {
        super("GLOBAL_WELL_SEARCH");
        this.viewContext = viewContext;
    }

    @Override
    public void resolve(final ViewLocator locator) throws UserFailureException {
        DispatcherHelper.dispatchNaviEvent(new AbstractTabItemFactory(){

            @Override
            public String getId() {
                return "openbis_-screening-GLOBAL_WELL_SEARCH";
            }

            @Override
            public ITabItem create() {
                String materialsList = GlobalWellSearchLocatorResolver.getOptionalParameter(locator, "items");
                if (materialsList != null) {
                    materialsList = MaterialCodeUtils.decode(materialsList);
                }
                Boolean exactMatchOnly = GlobalWellSearchLocatorResolver.getOptionalBooleanParameter(locator, "isExactSearch");
                boolean showCombinedResults = GlobalWellSearchLocatorResolver.getOptionalBooleanParameter(locator, "showCombinedResults", true);
                WellSearchComponent wellSearchTab = new WellSearchComponent(GlobalWellSearchLocatorResolver.this.viewContext, materialsList, exactMatchOnly, showCombinedResults);
                return DefaultTabItem.createUnaware(wellSearchTab, false, GlobalWellSearchLocatorResolver.this.viewContext);
            }

            @Override
            public String tryGetLink() {
                return locator.getHistoryToken();
            }

            @Override
            public String getTabTitle() {
                return WellSearchComponent.getTabTitle(GlobalWellSearchLocatorResolver.this.viewContext);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return null;
            }
        });
    }

    public static String createQueryBrowserLink() {
        URLMethodWithParameters url = new URLMethodWithParameters("");
        url.addParameter("action", "GLOBAL_WELL_SEARCH");
        return url.toStringWithoutDelimiterPrefix();
    }
}

