/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.comparators.NullComparator;

class ReplicateSequenceProvider {
    private final List<String> biologicalReplicatePropertyTypeCodesOrNull;
    private final Map<Double, Integer> biologicalReplicateSeqMap;
    private final Map<Long, Integer> technicalReplicateSeqMap;

    public ReplicateSequenceProvider(List<? extends IEntityPropertiesHolder> replicaWells, List<String> biologicalReplicatePropertyTypeCodesOrNull) {
        this.biologicalReplicatePropertyTypeCodesOrNull = biologicalReplicatePropertyTypeCodesOrNull;
        this.biologicalReplicateSeqMap = new LinkedHashMap<Double, Integer>();
        this.technicalReplicateSeqMap = new LinkedHashMap<Long, Integer>();
        GroupByMap<Double, IEntityPropertiesHolder> biologicalReplicates = this.groupByBiologicalReplicate(replicaWells);
        int biologicalReplicateSeq = 1;
        for (Double biologicalReplicateKey : ReplicateSequenceProvider.createSortedCopy(biologicalReplicates.getKeys())) {
            if (biologicalReplicateKey != null) {
                this.biologicalReplicateSeqMap.put(biologicalReplicateKey, biologicalReplicateSeq++);
            }
            int technicalReplicateSeq = 1;
            List<IEntityPropertiesHolder> technicalReplicates = biologicalReplicates.getOrDie(biologicalReplicateKey);
            for (IEntityPropertiesHolder technicalReplicate : technicalReplicates) {
                this.technicalReplicateSeqMap.put(technicalReplicate.getId(), technicalReplicateSeq++);
            }
        }
    }

    public Collection<Integer> getBiologicalReplicateSequences() {
        return ReplicateSequenceProvider.createSortedCopy(this.biologicalReplicateSeqMap.values());
    }

    private GroupByMap<Double, IEntityPropertiesHolder> groupByBiologicalReplicate(List<? extends IEntityPropertiesHolder> wells) {
        return GroupByMap.create(wells, new IGroupKeyExtractor<Double, IEntityPropertiesHolder>(){

            @Override
            public Double getKey(IEntityPropertiesHolder well) {
                return ReplicateSequenceProvider.this.tryFindSubgroup(well);
            }
        });
    }

    public boolean isBiologicalReplicate(IEntityPropertiesHolder well) {
        return this.tryFindSubgroup(well) != null;
    }

    public Integer tryGetBiologicalReplicateSequence(IEntityPropertiesHolder well) {
        Double subgroupKey = this.tryFindSubgroup(well);
        if (subgroupKey == null) {
            return null;
        }
        Integer seqNum = this.biologicalReplicateSeqMap.get(subgroupKey);
        assert (seqNum != null) : "no biological replicate found for " + subgroupKey;
        return seqNum;
    }

    public int getTechnicalReplicateSequence(IEntityPropertiesHolder well) {
        return this.technicalReplicateSeqMap.get(well.getId());
    }

    private static <T extends Comparable<T>> Collection<T> createSortedCopy(Collection<T> keys) {
        ArrayList<T> sortedKeys = new ArrayList<T>(keys);
        Collections.sort(sortedKeys, new NullComparator(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        }));
        return sortedKeys;
    }

    public String tryGetBiologicalReplicateLabel(IEntityPropertiesHolder well) {
        Integer biologicalReplicateSeq = this.tryGetBiologicalReplicateSequence(well);
        if (biologicalReplicateSeq == null) {
            return null;
        }
        IEntityProperty subgroupProperty = this.tryFindSubgroupProperty(well);
        assert (subgroupProperty != null) : "cannot fnd the subgroup property";
        boolean isMaterialProperty = subgroupProperty.getMaterial() != null;
        String propertyLabel = subgroupProperty.getPropertyType().getLabel();
        if (isMaterialProperty) {
            return String.valueOf(propertyLabel) + " " + biologicalReplicateSeq;
        }
        return String.valueOf(propertyLabel) + " " + subgroupProperty.tryGetAsString();
    }

    private Double tryFindSubgroup(IEntityPropertiesHolder well) {
        IEntityProperty subgroupProperty = this.tryFindSubgroupProperty(well);
        if (subgroupProperty == null) {
            return null;
        }
        return ReplicateSequenceProvider.tryExtractSubgroupValue(subgroupProperty);
    }

    private IEntityProperty tryFindSubgroupProperty(IEntityPropertiesHolder well) {
        if (this.biologicalReplicatePropertyTypeCodesOrNull == null) {
            return null;
        }
        return ReplicateSequenceProvider.tryFindProperty(well.getProperties(), this.biologicalReplicatePropertyTypeCodesOrNull);
    }

    private static Double tryExtractSubgroupValue(IEntityProperty subgroupProperty) {
        Material subgroupMaterial = subgroupProperty.getMaterial();
        if (subgroupMaterial != null) {
            return new Double(subgroupMaterial.getId().longValue());
        }
        try {
            return new Double(subgroupProperty.tryGetAsString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static IEntityProperty tryFindProperty(List<IEntityProperty> properties, List<String> subgroupPropertyTypeCodes) {
        for (IEntityProperty property : properties) {
            if (!subgroupPropertyTypeCodes.contains(property.getPropertyType().getCode())) continue;
            return property;
        }
        return null;
    }
}

