/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkBKGD
extends PngChunk {
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int paletteIndex;

    public PngChunkBKGD(ImageInfo info) {
        super("bKGD", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = null;
        if (this.imgInfo.greyscale) {
            c = this.createEmptyChunk(2, true);
            PngHelper.writeInt2tobytes(this.gray, c.data, 0);
        } else if (this.imgInfo.indexed) {
            c = this.createEmptyChunk(1, true);
            c.data[0] = (byte)this.paletteIndex;
        } else {
            c = this.createEmptyChunk(6, true);
            PngHelper.writeInt2tobytes(this.red, c.data, 0);
            PngHelper.writeInt2tobytes(this.green, c.data, 0);
            PngHelper.writeInt2tobytes(this.blue, c.data, 0);
        }
        return c;
    }

    public void parseFromChunk(ChunkRaw c) {
        if (this.imgInfo.greyscale) {
            this.gray = PngHelper.readInt2fromBytes(c.data, 0);
        } else if (this.imgInfo.indexed) {
            this.paletteIndex = c.data[0] & 0xFF;
        } else {
            this.red = PngHelper.readInt2fromBytes(c.data, 0);
            this.green = PngHelper.readInt2fromBytes(c.data, 2);
            this.blue = PngHelper.readInt2fromBytes(c.data, 4);
        }
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkBKGD otherx = (PngChunkBKGD)other;
        this.gray = otherx.gray;
        this.red = otherx.red;
        this.green = otherx.red;
        this.blue = otherx.red;
        this.paletteIndex = otherx.paletteIndex;
    }
}

