/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;

public final class HDF5GenericStorageFeatures
extends HDF5AbstractStorageFeatures {
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION = new HDF5GenericStorageFeatures(null, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION_KEEP = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_NO_COMPRESSION_DELETE = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_COMPACT_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.COMPACT, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CONTIGUOUS_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.CONTIGUOUS, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED_KEEP = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_CHUNKED_DELETE = new HDF5GenericStorageFeatures(HDF5StorageLayout.CHUNKED, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 0, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE = new HDF5GenericStorageFeatures(null, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_SHUFFLE_DEFLATE = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, true, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_KEEP = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_DELETE = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 6, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX = new HDF5GenericStorageFeatures(null, 9, -1);
    public static final HDF5GenericStorageFeatures GENERIC_SHUFFLE_DEFLATE_MAX = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, true, 9, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX_KEEP = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING, 9, -1);
    public static final HDF5GenericStorageFeatures GENERIC_DEFLATE_MAX_DELETE = new HDF5GenericStorageFeatures(null, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW, 9, -1);

    public static HDF5GenericStorageFeatures createDeflation(int deflationLevel) {
        return HDF5GenericStorageFeatures.createDeflation(deflationLevel, false);
    }

    public static HDF5GenericStorageFeatures createDeflationKeep(int deflationLevel) {
        return HDF5GenericStorageFeatures.createDeflation(deflationLevel, true);
    }

    private static HDF5GenericStorageFeatures createDeflation(int deflationLevel, boolean keepDataSetIfExists) {
        if (deflationLevel == 0) {
            return GENERIC_NO_COMPRESSION;
        }
        if (deflationLevel == 6) {
            return GENERIC_DEFLATE;
        }
        if (deflationLevel == 9) {
            return GENERIC_DEFLATE_MAX;
        }
        return new HDF5GenericStorageFeatures(null, HDF5GenericStorageFeatures.getDataSetReplacementPolicy(keepDataSetIfExists, false), HDF5GenericStorageFeatures.toByte(deflationLevel), -1);
    }

    static HDF5GenericStorageFeatures getCompression(boolean deflate) {
        return deflate ? GENERIC_DEFLATE : GENERIC_NO_COMPRESSION;
    }

    public static HDF5GenericStorageFeatureBuilder build() {
        return new HDF5GenericStorageFeatureBuilder();
    }

    public static HDF5GenericStorageFeatureBuilder build(HDF5GenericStorageFeatures template) {
        return new HDF5GenericStorageFeatureBuilder(template);
    }

    HDF5GenericStorageFeatures(HDF5GenericStorageFeatureBuilder builder) {
        super(builder.getStorageLayout(), builder.getDatasetReplacementPolicy(), builder.isShuffleBeforeDeflate(), builder.getDeflateLevel(), builder.getScalingFactor());
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, byte deflateLevel, byte scalingFactor) {
        this(proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy.USE_WRITER_DEFAULT, deflateLevel, scalingFactor);
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, deflateLevel, scalingFactor);
    }

    HDF5GenericStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, HDF5AbstractStorageFeatures.DataSetReplacementPolicy dataSetReplacementPolicy, boolean shuffleBeforeDeflate, byte deflateLevel, byte scalingFactor) {
        super(proposedLayoutOrNull, dataSetReplacementPolicy, shuffleBeforeDeflate, deflateLevel, scalingFactor);
    }

    @Override
    boolean isCompatibleWithDataClass(int dataClassId) {
        return true;
    }

    public static final class HDF5GenericStorageFeatureBuilder
    extends HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder {
        public HDF5GenericStorageFeatureBuilder() {
        }

        public HDF5GenericStorageFeatureBuilder(HDF5GenericStorageFeatures template) {
            super(template);
        }

        @Override
        public HDF5GenericStorageFeatureBuilder compress(boolean compress) {
            super.compress(compress);
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder compress() {
            super.compress();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder deflateLevel(byte deflateLevel) {
            super.deflateLevel(deflateLevel);
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder shuffleBeforeDeflate(boolean shuffleBeforeDeflate) {
            super.shuffleBeforeDeflate(shuffleBeforeDeflate);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder shuffleBeforeDeflate() {
            super.shuffleBeforeDeflate();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder storageLayout(HDF5StorageLayout proposedLayout) {
            super.storageLayout(proposedLayout);
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder compactStorageLayout() {
            super.compactStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder contiguousStorageLayout() {
            super.contiguousStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder chunkedStorageLayout() {
            super.chunkedStorageLayout();
            return this;
        }

        @Override
        public HDF5AbstractStorageFeatures.HDF5AbstractStorageFeatureBuilder defaultStorageLayout() {
            this.defaultStorageLayout();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder datasetReplacementPolicy(HDF5AbstractStorageFeatures.DataSetReplacementPolicy datasetReplacementPolicy) {
            super.datasetReplacementPolicy(datasetReplacementPolicy);
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder datasetReplacementUseWriterDefault() {
            super.datasetReplacementUseWriterDefault();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder datasetReplacementEnforceKeepExisting() {
            super.datasetReplacementEnforceKeepExisting();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatureBuilder datasetReplacementEnforceReplaceWithNew() {
            super.datasetReplacementEnforceReplaceWithNew();
            return this;
        }

        @Override
        public HDF5GenericStorageFeatures features() {
            return new HDF5GenericStorageFeatures(this);
        }
    }
}

