/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;

public class LambertAzimuthal
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "lambert_azimuthal_equal_area";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin");
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin");
        double false_easting = this.readAttributeDouble(ctv, "false_easting");
        double false_northing = this.readAttributeDouble(ctv, "false_northing");
        if (!Double.isNaN(false_easting) || !Double.isNaN(false_northing)) {
            double scalef = this.getFalseEastingScaleFactor(ds, ctv);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        LambertAzimuthalEqualArea proj = new LambertAzimuthalEqualArea(lat0, lon0, false_easting, false_northing, ProjectionImpl.EARTH_RADIUS);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

